<?php $__env->startSection('content'); ?>
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2"><?php echo e(__('site.logs')); ?></h1>
    </div>
    <div class="col-6">
        <select class="form-select" name="nebim" id="filter">
            <?php if(request('has_error') == null): ?>
                <option selected value="0"><?php echo e(__('site.alllogs')); ?></option>
            <?php else: ?>
                <option value="0"><?php echo e(__('site.alllogs')); ?></option>
            <?php endif; ?>
            <?php if(request('has_error') == 1): ?>
                <option value="1" selected><?php echo e(__('site.unlogs')); ?></option>
            <?php else: ?>
                <option value="1"><?php echo e(__('site.unlogs')); ?></option>
            <?php endif; ?>
        </select>


        <a href="<?php echo e(route('logs-delete')); ?>"
           class="mt-4 btn btn-info">
            <?php echo e(__('site.clearlogs')); ?></a>
    </div>

    <div class="row mt-5">

        <table class="table table-hover">
            <tbody>
            <th><?php echo e(__('site.project')); ?></th>
            <th><?php echo e(__('site.message')); ?></th>
            <th><?php echo e(__('site.status')); ?></th>
            <th><?php echo e(__('site.date')); ?></th>
            </tbody>
            <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\App\Models\ProjectSettings::getProjectName($log->integrationId)); ?></td>
                    <td style="max-width:200px;overflow:auto"><?php echo e($log->message); ?></td>
                    <td><?php echo $log->has_error ? '<span class="badge bg-danger">Başarısız</span>' : '<span class="badge bg-success">Başarılı</span>'; ?></td>
                    <td><?php echo e($log->created_at); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>

        <div class="col-6 m-auto">
            <?php if($logs): ?>
                <?php echo e($logs->links()); ?>

            <?php endif; ?>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $("#filter").change(function () {
            var value = $(this).val();
            var url = new URL(window.location.href);
            url.searchParams.set('has_error', value);
            window.location.href = url.href;
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/roothr/public_html/integrator/resources/views/logs.blade.php ENDPATH**/ ?>