<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="Burak Erenel">
    <title>Tudors Entegrasyon</title>
    <!-- Bootstrap core CSS -->
    <link href="<?php echo e(asset('assets/dist/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <style>
        .bd-placeholder-img {
            font-size: 1.125rem;
            text-anchor: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
        }

        @media (min-width: 768px) {
            .bd-placeholder-img-lg {
                font-size: 3.5rem;
            }
        }
    </style>


    <!-- Custom styles for this template -->
    <link href="<?php echo e(asset('dashboard.css')); ?>" rel="stylesheet">
</head>
<body>

<header class="navbar navbar-dark sticky-top bg-dark flex-md-nowrap p-0 shadow">
    <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3" href="#"><?php echo e(__('site.title')); ?></a>
    <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse"
            data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false"
            aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
</header>

<div class="container-fluid">
    <div class="row">
        <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
            <div class="position-sticky pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link" aria-current="page" href="<?php echo e(route('login')); ?>">
                            <span data-feather="home"></span>
                            <?php echo e(__('site.login')); ?>

                        </a>
                    </li>
                </ul>

            </div>
        </nav>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">

            <div
                class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php echo e(__('site.login')); ?></h1>
            </div>

            <div class="row">
                <div class="col-4">
                    <form method="post" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>

                        <input type="hidden" name="email" value="integrator@tudors.com">
                        <div class="form-group">
                            <label for="password"><?php echo e(__('site.password')); ?></label>
                            <input type="password" name="password" class="form-control" id="password" placeholder="<?php echo e(__('site.password')); ?>">
                        </div>
                        <div class="form-group mt-2">
                            <button type="submit" class="btn btn-primary"><?php echo e(__('site.login')); ?></button>
                        </div>
                    </form>
                </div>

            </div>


        </main>
    </div>
</div>


<script src="<?php echo e(asset('assets/dist/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/feather-icons@4.28.0/dist/feather.min.js"
        integrity="sha384-uO3SXW5IuS1ZpFPKugNNWqTZRRglnUJK6UAZ/gxOX80nxEkN9NcGZTftn6RzhGWE"
        crossorigin="anonymous"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<script src="<?php echo e(asset('dashboard.js')); ?>"></script>
<?php echo $__env->yieldContent('js'); ?>
</body>
</html>
<?php /**PATH /home/rootkz/public_html/integrator/resources/views/login.blade.php ENDPATH**/ ?>