<?php $__env->startSection('content'); ?>
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2"><?php echo e(__('site.products')); ?></h1>
    </div>

    <div class="row">
        <form method="get" action="<?php echo e(route('products')); ?>">
            <div class="row">
                <div class="col-6">
                    <select class="form-select" name="project">
                        <?php if(!request('project')): ?>
                            <option selected><?php echo e(__('site.selectproject')); ?></option>
                        <?php else: ?>
                            <option><?php echo e(__('site.selectproject')); ?></option>
                        <?php endif; ?>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(request('project') == $project->id): ?>
                                <option value="<?php echo e($project->id); ?>" selected><?php echo e($project->project_name); ?></option>
                            <?php else: ?>
                                <option value="<?php echo e($project->id); ?>"><?php echo e($project->project_name); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-6">
                    <select class="form-select" name="image" id="imageFilter">
                        <?php if(!request('image')): ?>
                            <option selected value="0"><?php echo e(__('site.allproducts')); ?></option>
                        <?php else: ?>
                            <option value="0"><?php echo e(__('site.allproducts')); ?></option>
                        <?php endif; ?>
                        <?php if(request('image') == 1): ?>
                            <option value="1" selected><?php echo e(__('site.haveimages')); ?></option>
                        <?php else: ?>
                            <option value="1"><?php echo e(__('site.haveimages')); ?></option>
                        <?php endif; ?>
                        <?php if(request('image') == 2): ?>
                            <option value="2" selected><?php echo e(__('site.noimages')); ?></option>
                        <?php else: ?>
                            <option value="2"><?php echo e(__('site.noimages')); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="row mt-3">
                <?php if($currentProject): ?>
                    <div class="col-3">
                        <div class="form-group">
                            <label for="model"><?php echo e(__('site.model')); ?></label>
                            <input type="text" class="form-control" id="model" name="model"
                                   placeholder="Model" value="<?php echo e(request('model')); ?>">
                        </div>

                    </div>

                    <div class="col-3">
                        <div class="form-group">
                            <label for="sku"><?php echo e(__('site.sku')); ?></label>
                            <input type="text" class="form-control" id="sku" name="sku"
                                   placeholder="Sku" value="<?php echo e(request('sku')); ?>">
                        </div>
                    </div>

                    <div class="col-3">
                        <div class="form-group">
                            <label for="ean"><?php echo e(__('site.barcode')); ?></label>
                            <input type="text" class="form-control" id="ean" name="ean"
                                   placeholder="<?php echo e(__('site.barcode')); ?>" value="<?php echo e(request('ean')); ?>">
                        </div>
                    </div>

                <?php endif; ?>
            </div>
            <div class="col-4">
                <button type="submit" class="mt-4 btn btn-primary"><?php echo e(__('site.filter')); ?></button>
            </div>
            <?php if($currentProject): ?>

                <a href="<?php echo e(route('product-sync',$currentProject)); ?>" target="_blank"
                   class="mt-4 btn btn-info">
                    <?php echo e(__('site.syncproduct')); ?></a>
                <a href="<?php echo e(route('stock-and-price-sync',$currentProject)); ?>" target="_blank"
                   class="mt-4 btn btn-warning"><?php echo e(__('site.syncinventoryprice')); ?></a>
                <a href="<?php echo e(route('related-sync',$currentProject)); ?>" target="_blank"
                   class="mt-4 btn btn-success">
                    <?php echo e(__('site.syncfeaturedproduct')); ?></a>
                <a href="<?php echo e(route('image-sync',$currentProject)); ?>" target="_blank" class="mt-4 btn btn-info">
                    <?php echo e(__('site.syncimage')); ?></a>
    <a href="<?php echo e(route('getPriceUpdate',$currentProject)); ?>" target="_blank" class="mt-4 btn btn-success">
                    <?php echo e(__('site.syncprice')); ?></a>

            <?php endif; ?>
        </form>
    </div>

    <div class="row mt-5">
        <?php if(isset($products)): ?>
        <?php if($products): ?>
        <span
            class="p-1">
<strong><?php echo e(__('site.totalproduct')); ?>:</strong> <?php echo e($products->total()); ?> <?php echo e(__('site.product')); ?>  <strong><?php echo e(__('site.totalinventory')); ?>:</strong> <?php echo e($totalStock); ?> <?php echo e(__('site.piece')); ?>


            </span>
<?php endif; ?>
<?php endif; ?>

        <table class="table table-hover">
            <tbody>
            <th><?php echo e(__('site.productno')); ?></th>
            <th><?php echo e(__('site.model')); ?></th>
            <th><?php echo e(__('site.sku')); ?></th>
            <th><?php echo e(__('site.barcode')); ?></th>
            <th><?php echo e(__('site.opinventory')); ?></th>

            <th><?php echo e(__('site.opprice')); ?></th>
            <th><?php echo e(__('site.opdiscountprice')); ?></th>
            <th><?php echo e(__('site.inprice')); ?></th>
            <th><?php echo e(__('site.indiscountprice')); ?></th>
            <th><?php echo e(__('site.mainimage')); ?></th>
            <th><?php echo e(__('site.childimage')); ?></th>


            </tbody>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($product->product_id); ?></td>
                    <td><?php echo e($product->model); ?></td>
                    <td><?php echo e($product->sku); ?></td>
                    <td><?php echo e($product->ean); ?></td>
                    <td><?php echo e($product->quantity); ?></td>


                    <td><?php echo e($product->price); ?></td>
                    <td>
                        <?php if($product->special->first() == TRUE): ?>
                        <?php echo e($product->special->first()->price); ?>


                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($product->integration == TRUE): ?>
                                                <?php echo e($product->integration->Price2); ?>



                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($product->integration == TRUE): ?>
                        <?php echo e($product->integration->Price1); ?>


                        <?php endif; ?>
                    </td>
                    <td>
<?php if($product->image == TRUE): ?>
<img class="lazy img-thumbnail" data-src="<?php echo e($product->image); ?>" style="height: 75px;" alt="..." >

                        <?php else: ?>

-
                        <?php endif; ?>
                    </td>
                    <td>

                        <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<img class="lazy img-thumbnail" data-src="<?php echo e($img->image); ?>" style="height: 75px;" alt="..." >

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>

        <div class="col-6 m-auto">
            <?php if($products): ?>
                <?php echo e($products->links()); ?>

            <?php endif; ?>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- cdnjs -->
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.min.js"></script>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.plugins.min.js"></script>
    <script>
        $("#imageFilter").change(function () {
            var value = $(this).val();
            var url = new URL(window.location.href);
            url.searchParams.set('image', value);
            window.location.href = url.href;
        });
          $(function() {
        $('.lazy').Lazy();
    });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/roothr/public_html/integrator/resources/views/products.blade.php ENDPATH**/ ?>