<?php $__env->startSection('content'); ?>
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2"><?php echo e(__('site.orders')); ?></h1>
    </div>

    <div class="row">
        <form method="get" action="<?php echo e(route('orders')); ?>">
            <div class="row">
                <div class="col-6">
                    <select class="form-select" name="project">
                        <?php if(!request('project')): ?>
                            <option selected><?php echo e(__('site.selectproject')); ?></option>
                        <?php else: ?>
                            <option><?php echo e(__('site.selectproject')); ?></option>
                        <?php endif; ?>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(request('project') == $project->id): ?>
                                <option value="<?php echo e($project->id); ?>" selected><?php echo e($project->project_name); ?></option>
                            <?php else: ?>
                                <option value="<?php echo e($project->id); ?>"><?php echo e($project->project_name); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-6">
                    <select class="form-select" name="nebim" id="filter">
                        <?php if(request('nebim') == null): ?>
                            <option selected value="0"><?php echo e(__('site.allorders')); ?></option>
                        <?php else: ?>
                            <option value="0"><?php echo e(__('site.allorders')); ?></option>
                        <?php endif; ?>
                        <?php if(request('nebim') == 2): ?>
                            <option value="2" selected><?php echo e(__('site.nebimwaiting')); ?></option>
                        <?php else: ?>
                            <option value="2"><?php echo e(__('site.nebimwaiting')); ?></option>
                        <?php endif; ?>
                        <?php if(request('nebim') == 1): ?>
                            <option value="1" selected><?php echo e(__('site.nebimok')); ?></option>
                        <?php else: ?>
                            <option value="1"><?php echo e(__('site.nebimok')); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="row mt-3">
                <?php if($currentProject): ?>
                    <div class="col-3">
                        <div class="form-group">
                            <label for="order_id"><?php echo e(__('site.ordernumber')); ?></label>
                            <input type="text" class="form-control" id="order_id" name="order_id"
                                   placeholder="<?php echo e(__('site.ordernumber')); ?>" value="<?php echo e(request('order_id')); ?>">
                        </div>
                    </div>


                <?php endif; ?>
            </div>
            <div class="col-4">
                <button type="submit" class="mt-4 btn btn-primary"><?php echo e(__('site.filter')); ?></button>
                <?php if($currentProject): ?>
                    <a href="<?php echo e(route('order-sync',$currentProject)); ?>" target="_blank" class="mt-4 btn btn-info"><?php echo e(__('site.nowsyncorders')); ?></a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <div class="row mt-5">

        <table class="table table-hover">
            <tbody>
            <th><?php echo e(__('site.ordernumber')); ?></th>
            <th><?php echo e(__('site.buyer')); ?></th>
            <th><?php echo e(__('site.email')); ?></th>
            <th><?php echo e(__('site.orderstatus')); ?></th>
            <th><?php echo e(__('site.ordertotal')); ?></th>
            <th><?php echo e(__('site.nebim')); ?></th>
            </tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($order->order_id); ?></td>
                    <td><?php echo e($order->firstname); ?> <?php echo e($order->lastname); ?></td>
                    <td><?php echo e($order->email); ?></td>
                    <td><?php echo e(($order->status) ? $order->status->name : "-"); ?></td>
                    <td><?php echo e($order->total); ?> <?php echo e($order->currency_code); ?></td>
                    <td><?php echo e($order->nebim ? 'Aktarıldı' : 'Bekliyor'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>

        <div class="col-6 m-auto">
            <?php if($orders): ?>
                <?php echo e($orders->links()); ?>

            <?php endif; ?>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $("#filter").change(function () {
            var value = $(this).val();
            var url = new URL(window.location.href);
            url.searchParams.set('nebim', value);
            window.location.href = url.href;
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rootrs/public_html/integrator/resources/views/orders.blade.php ENDPATH**/ ?>