<?php

use App\Http\Controllers\TestController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::get('/', [\App\Http\Controllers\DashboardController::class, 'dashboard'])->name('dashboard')->middleware('auth');
Route::get('/dashboard', [\App\Http\Controllers\DashboardController::class, 'dashboard'])->name('dashboard')->middleware('auth');
Route::get('/login', function () {
	return view('login');
})->name('login');
Route::post('/login', [\App\Http\Controllers\DashboardController::class, 'login'])->name('login');
Route::get('/logout', function () {
	\Illuminate\Support\Facades\Auth::logout();
	return redirect('/login');
})->name('logout');

Route::get('/password-update', function () {
	return view('password-update');
})->name('password-update')->middleware('auth');
Route::post('/password-update', [\App\Http\Controllers\DashboardController::class, 'passwordUpdate'])->name('password-update')->middleware('auth');

Route::get('/integrations', [\App\Http\Controllers\IntegrationController::class, 'list'])->name('integrations')->middleware('auth');
Route::get('/integration-add', function () {
	return view('integration-add');
})->name('integration-add')->middleware('auth');
Route::post('/integration-add', [\App\Http\Controllers\IntegrationController::class, 'create'])->name('integration-add')->middleware('auth');
Route::get('/integration-edit/{id}', [\App\Http\Controllers\IntegrationController::class, 'edit'])->name('integration-edit')->middleware('auth');
Route::post('/integration-edit/{id}', [\App\Http\Controllers\IntegrationController::class, 'editForm'])->name('integration-edit')->middleware('auth');
Route::get('/integration-delete/{id}', [\App\Http\Controllers\IntegrationController::class, 'delete'])->name('integration-delete')->middleware('auth');

Route::get('/products', [\App\Http\Controllers\OpController::class, 'products'])->name('products')->middleware('auth');
Route::get('/products-price-update/{id}', [\App\Http\Controllers\OpController::class, 'getPriceUpdate'])->name('getPriceUpdate')->middleware('auth');
Route::get('/orders', [\App\Http\Controllers\OpController::class, 'orders'])->name('orders')->middleware('auth');
Route::get('/logs', [\App\Http\Controllers\LogsController::class, 'list'])->name('logs')->middleware('auth');

Route::get('/stock-and-price-sync/{id}', [\App\Http\Controllers\IntegrationController::class, 'stockAndPriceSync'])->name('stock-and-price-sync')->middleware('auth');
Route::get('/product-sync/{id}', [\App\Http\Controllers\IntegrationController::class, 'productSync'])->name('product-sync')->middleware('auth');
Route::get('/order-sync/{id}', [\App\Http\Controllers\IntegrationController::class, 'orderSync'])->name('order-sync')->middleware('auth');
Route::get('/related-sync/{id}', [\App\Http\Controllers\IntegrationController::class, 'relatedSync'])->name('related-sync')->middleware('auth');
Route::get('/image-sync/{id}', [\App\Http\Controllers\IntegrationController::class, 'imageSync'])->name('image-sync')->middleware('auth');
Route::get('/logs-delete', [\App\Http\Controllers\LogsController::class, 'logsDelete'])->name('logs-delete')->middleware('auth');
Route::get('language/{locale}', function ($locale) {
	app()->setLocale($locale);
	session()->put('locale', $locale);
	return redirect()->back();
});
Route::get('/migrate', function () {
	\Artisan::call('migrate');
	dd('migrated!');
});

Route::get('/featured', function () {
	\Artisan::call('nebim:featured 1');
});

Route::get('/image-fix', function () {
	\Artisan::call('op:images-fix');
});

Route::get('/scheduler/run', function () {
	\Artisan::call('nebim:order');
	\Artisan::call('nebim:stock-and-price');
	\Artisan::call('nebim:product-sync');
	\Artisan::call('nebim:images');
});

Route::get('/server-info', function () {
	phpinfo();
});

Route::prefix('test')->group(function () {
    Route::get('/stok-price-service', [TestController::class, 'testStokPriceService']);
});
