@extends('app')
@section('content')
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{__('site.products')}}</h1>
    </div>

    <div class="row">
        <form method="get" action="{{route('products')}}">
            <div class="row">
                <div class="col-6">
                    <select class="form-select" name="project">
                        @if(!request('project'))
                            <option selected>{{__('site.selectproject')}}</option>
                        @else
                            <option>{{__('site.selectproject')}}</option>
                        @endif
                        @foreach($projects as $project)
                            @if(request('project') == $project->id)
                                <option value="{{$project->id}}" selected>{{$project->project_name}}</option>
                            @else
                                <option value="{{$project->id}}">{{$project->project_name}}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
                <div class="col-6">
                    <select class="form-select" name="image" id="imageFilter">
                        @if(!request('image'))
                            <option selected value="0">{{__('site.allproducts')}}</option>
                        @else
                            <option value="0">{{__('site.allproducts')}}</option>
                        @endif
                        @if(request('image') == 1)
                            <option value="1" selected>{{__('site.haveimages')}}</option>
                        @else
                            <option value="1">{{__('site.haveimages')}}</option>
                        @endif
                        @if(request('image') == 2)
                            <option value="2" selected>{{__('site.noimages')}}</option>
                        @else
                            <option value="2">{{__('site.noimages')}}</option>
                        @endif
                    </select>
                </div>
            </div>
            <div class="row mt-3">
                @if($currentProject)
                    <div class="col-3">
                        <div class="form-group">
                            <label for="model">{{__('site.model')}}</label>
                            <input type="text" class="form-control" id="model" name="model"
                                   placeholder="Model" value="{{request('model')}}">
                        </div>

                    </div>

                    <div class="col-3">
                        <div class="form-group">
                            <label for="sku">{{__('site.sku')}}</label>
                            <input type="text" class="form-control" id="sku" name="sku"
                                   placeholder="Sku" value="{{request('sku')}}">
                        </div>
                    </div>

                    <div class="col-3">
                        <div class="form-group">
                            <label for="ean">{{__('site.barcode')}}</label>
                            <input type="text" class="form-control" id="ean" name="ean"
                                   placeholder="{{__('site.barcode')}}" value="{{request('ean')}}">
                        </div>
                    </div>

                @endif
            </div>
            <div class="col-4">
                <button type="submit" class="mt-4 btn btn-primary">{{__('site.filter')}}</button>
            </div>
            @if($currentProject)

                <a href="{{route('product-sync',$currentProject)}}" target="_blank"
                   class="mt-4 btn btn-info">
                    {{__('site.syncproduct')}}</a>
                <a href="{{route('stock-and-price-sync',$currentProject)}}" target="_blank"
                   class="mt-4 btn btn-warning">{{__('site.syncinventoryprice')}}</a>
                <a href="{{route('related-sync',$currentProject)}}" target="_blank"
                   class="mt-4 btn btn-success">
                    {{__('site.syncfeaturedproduct')}}</a>
                <a href="{{route('image-sync',$currentProject)}}" target="_blank" class="mt-4 btn btn-info">
                    {{__('site.syncimage')}}</a>
    <a href="{{route('getPriceUpdate',$currentProject)}}" target="_blank" class="mt-4 btn btn-success">
                    {{__('site.syncprice')}}</a>

            @endif
        </form>
    </div>

    <div class="row mt-5">
        @if(isset($products))
        @if($products)
        <span
            class="p-1">
<strong>{{__('site.totalproduct')}}:</strong> {{$products->total()}} {{__('site.product')}}  <strong>{{__('site.totalinventory')}}:</strong> {{$totalStock}} {{__('site.piece')}}

            </span>
@endif
@endif

        <table class="table table-hover">
            <tbody>
            <th>{{__('site.productno')}}</th>
            <th>{{__('site.model')}}</th>
            <th>{{__('site.sku')}}</th>
            <th>{{__('site.barcode')}}</th>
            <th>{{__('site.opinventory')}}</th>

            <th>{{__('site.opprice')}}</th>
            <th>{{__('site.opdiscountprice')}}</th>
            <th>{{__('site.inprice')}}</th>
            <th>{{__('site.indiscountprice')}}</th>
            <th>{{__('site.mainimage')}}</th>
            <th>{{__('site.childimage')}}</th>


            </tbody>
            @foreach($products as $product)
                <tr>
                    <td>{{$product->product_id}}</td>
                    <td>{{$product->model}}</td>
                    <td>{{$product->sku}}</td>
                    <td>{{$product->ean}}</td>
                    <td>{{$product->quantity}}</td>


                    <td>{{$product->price}}</td>
                    <td>
                        @if($product->special->first() == TRUE)
                        {{$product->special->first()->price}}

                        @endif
                    </td>
                    <td>
                        @if($product->integration == TRUE)
                                                {{$product->integration->Price2}}


                        @endif
                    </td>
                    <td>
                        @if($product->integration == TRUE)
                        {{$product->integration->Price1}}

                        @endif
                    </td>
                    <td>
@if($product->image == TRUE)
<img class="lazy img-thumbnail" data-src="{{$product->image}}" style="height: 75px;" alt="..." >

                        @else

-
                        @endif
                    </td>
                    <td>

                        @foreach($product->images as $img)

<img class="lazy img-thumbnail" data-src="{{$img->image}}" style="height: 75px;" alt="..." >

                        @endforeach

                    </td>

                </tr>
            @endforeach
        </table>

        <div class="col-6 m-auto">
            @if($products)
                {{$products->links()}}
            @endif
        </div>
    </div>

@endsection()

@section('js')
<!-- cdnjs -->
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.min.js"></script>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.plugins.min.js"></script>
    <script>
        $("#imageFilter").change(function () {
            var value = $(this).val();
            var url = new URL(window.location.href);
            url.searchParams.set('image', value);
            window.location.href = url.href;
        });
          $(function() {
        $('.lazy').Lazy();
    });

    </script>
@endsection
