@extends('app')
@section('content')
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{__('site.passwordchange')}}</h1>
    </div>

    <div class="row">
        @if ($errors->any())
            <div class="alert alert-danger" role="alert">
                @foreach ($errors->all() as $error)
                    <b>{{ $error }}</b><br>
                @endforeach
            </div>
        @endif

        <form method="POST" action="{{route('password-update')}}">
            @csrf
            <div class="row">
                <div class="col-6 bg-light p-2 border border-light rounded">
                    <div class="form-group col-12">
                        <label for="password">{{__('site.newpassword')}}</label>
                        <input type="password" class="form-control" id="password" name="password"
                               placeholder="{{__('site.newpassword')}}">
                    </div>
                    <div class="form-group col-12">
                        <label for="password2">{{__('site.newpassword')}}</label>
                        <input type="password" class="form-control" id="password2" name="password_confirmation"
                               placeholder="{{__('site.newpassword')}}">
                    </div>

                </div>
            </div>
            <button type="submit" class="mt-4 btn btn-primary">Güncelle</button>
        </form>

    </div>
@endsection()
