@extends('app')
@section('content')
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{__('site.orders')}}</h1>
    </div>

    <div class="row">
        <form method="get" action="{{route('orders')}}">
            <div class="row">
                <div class="col-6">
                    <select class="form-select" name="project">
                        @if(!request('project'))
                            <option selected>{{__('site.selectproject')}}</option>
                        @else
                            <option>{{__('site.selectproject')}}</option>
                        @endif
                        @foreach($projects as $project)
                            @if(request('project') == $project->id)
                                <option value="{{$project->id}}" selected>{{$project->project_name}}</option>
                            @else
                                <option value="{{$project->id}}">{{$project->project_name}}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
                <div class="col-6">
                    <select class="form-select" name="nebim" id="filter">
                        @if(request('nebim') == null)
                            <option selected value="0">{{__('site.allorders')}}</option>
                        @else
                            <option value="0">{{__('site.allorders')}}</option>
                        @endif
                        @if(request('nebim') == 2)
                            <option value="2" selected>{{__('site.nebimwaiting')}}</option>
                        @else
                            <option value="2">{{__('site.nebimwaiting')}}</option>
                        @endif
                        @if(request('nebim') == 1)
                            <option value="1" selected>{{__('site.nebimok')}}</option>
                        @else
                            <option value="1">{{__('site.nebimok')}}</option>
                        @endif
                    </select>
                </div>
            </div>
            <div class="row mt-3">
                @if($currentProject)
                    <div class="col-3">
                        <div class="form-group">
                            <label for="order_id">{{__('site.ordernumber')}}</label>
                            <input type="text" class="form-control" id="order_id" name="order_id"
                                   placeholder="{{__('site.ordernumber')}}" value="{{request('order_id')}}">
                        </div>
                    </div>


                @endif
            </div>
            <div class="col-4">
                <button type="submit" class="mt-4 btn btn-primary">{{__('site.filter')}}</button>
                @if($currentProject)
                    <a href="{{route('order-sync',$currentProject)}}" target="_blank" class="mt-4 btn btn-info">{{__('site.nowsyncorders')}}</a>
                @endif
            </div>
        </form>
    </div>

    <div class="row mt-5">

        <table class="table table-hover">
            <tbody>
            <th>{{__('site.ordernumber')}}</th>
            <th>{{__('site.buyer')}}</th>
            <th>{{__('site.email')}}</th>
            <th>{{__('site.orderstatus')}}</th>
            <th>{{__('site.ordertotal')}}</th>
            <th>{{__('site.nebim')}}</th>
            </tbody>
            @foreach($orders as $order)
                <tr>
                    <td>{{$order->order_id}}</td>
                    <td>{{$order->firstname}} {{$order->lastname}}</td>
                    <td>{{$order->email}}</td>
                    <td>{{($order->status) ? $order->status->name : "-"}}</td>
                    <td>{{$order->total}} {{$order->currency_code}}</td>
                    <td>{{$order->nebim ? 'Aktarıldı' : 'Bekliyor'}}</td>
                </tr>
            @endforeach
        </table>

        <div class="col-6 m-auto">
            @if($orders)
                {{$orders->links()}}
            @endif
        </div>
    </div>

@endsection()

@section('js')
    <script>
        $("#filter").change(function () {
            var value = $(this).val();
            var url = new URL(window.location.href);
            url.searchParams.set('nebim', value);
            window.location.href = url.href;
        });
    </script>
@endsection
