@extends('app')
@section('content')
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{__('site.logs')}}</h1>
    </div>
    <div class="col-6">
        <select class="form-select" name="nebim" id="filter">
            @if(request('has_error') == null)
                <option selected value="0">{{__('site.alllogs')}}</option>
            @else
                <option value="0">{{__('site.alllogs')}}</option>
            @endif
            @if(request('has_error') == 1)
                <option value="1" selected>{{__('site.unlogs')}}</option>
            @else
                <option value="1">{{__('site.unlogs')}}</option>
            @endif
        </select>


        <a href="{{route('logs-delete')}}"
           class="mt-4 btn btn-info">
            {{__('site.clearlogs')}}</a>
    </div>

    <div class="row mt-5">

        <table class="table table-hover">
            <tbody>
            <th>{{__('site.project')}}</th>
            <th>{{__('site.message')}}</th>
            <th>{{__('site.status')}}</th>
            <th>{{__('site.date')}}</th>
            </tbody>
            @foreach($logs as $log)
                <tr>
                    <td>{{ \App\Models\ProjectSettings::getProjectName($log->integrationId)}}</td>
                    <td style="max-width:200px;overflow:auto">{{$log->message}}</td>
                    <td>{!!  $log->has_error ? '<span class="badge bg-danger">Başarısız</span>' : '<span class="badge bg-success">Başarılı</span>'!!}</td>
                    <td>{{$log->created_at}}</td>
                </tr>
            @endforeach
        </table>

        <div class="col-6 m-auto">
            @if($logs)
                {{$logs->links()}}
            @endif
        </div>
    </div>

@endsection()

@section('js')
    <script>
        $("#filter").change(function () {
            var value = $(this).val();
            var url = new URL(window.location.href);
            url.searchParams.set('has_error', value);
            window.location.href = url.href;
        });
    </script>
@endsection

