@extends('app')
@section('content')
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Entegrasyon Düzenle</h1>
    </div>

    <div class="row">
        @if ($errors->any())
            <div class="alert alert-danger" role="alert">
                @foreach ($errors->all() as $error)
                    <b>{{ $error }}</b><br>
                @endforeach
            </div>
        @endif

        <form method="POST" action="{{route('integration-edit',$projectSettings->id)}}">
            @csrf
            <div class="row">
                <div class="col-6 bg-light p-2 border border-light rounded">
                    <div class="form-group col-12">
                        <label for="project_name">Proje Adı</label>
                        <input type="text" class="form-control" id="project_name" name="project_name"
                               placeholder="Proje Adı" value="{{$projectSettings->project_name}}">
                    </div>

                    <div class="form-group">
                        <label for="database_host">Database Host</label>
                        <input type="text" class="form-control" id="database_host" name="database_host"
                               placeholder="Opencart Database Host (Varsayılan: localhost)"
                               value="{{$projectSettings->database_host}}">
                    </div>

                    <div class="form-group">
                        <label for="database_port">Database Port</label>
                        <input type="text" class="form-control" id="database_port" name="database_port"
                               placeholder="Opencart Database Port (Varsayılan: 3306)"
                               value="{{$projectSettings->database_port}}">
                    </div>

                    <div class="form-group">
                        <label for="database_name">Database Name</label>
                        <input type="text" class="form-control" id="database_name" name="database_name"
                               placeholder="Opencart Database Name" value="{{$projectSettings->database_name}}">
                    </div>

                    <div class="form-group">
                        <label for="database_username">Database Username</label>
                        <input type="text" class="form-control" id="database_username" name="database_username"
                               placeholder="Opencart Database Username" value="{{$projectSettings->database_username}}">
                    </div>

                    <div class="form-group">
                        <label for="database_password">Database Password</label>
                        <input type="password" class="form-control" id="database_password" name="database_password"
                               placeholder="Opencart Database Password" value="{{$projectSettings->database_password}}">
                    </div>
                </div>
                <div class="col-6 bg-secondary p-2 border border-secondary rounded">
                    <div class="form-group">
                        <label for="nebim_url">Nebim Url</label>
                        <input type="text" class="form-control" id="nebim_url" name="nebim_url" placeholder="Nebim Url"
                               value="{{$projectSettings->nebim_url}}">
                    </div>

                    <div class="form-group">
                        <label for="nebim_database_name">Nebim Database Name</label>
                        <input type="text" class="form-control" id="nebim_database_name" name="nebim_database_name"
                               placeholder="Nebim Database Name" value="{{$projectSettings->nebim_database_name}}">
                    </div>

                    <div class="form-group">
                        <label for="nebim_user_group_code">Nebim User Group Code</label>
                        <input type="text" class="form-control" id="nebim_user_group_code" name="nebim_user_group_code"
                               placeholder="Nebim User Group Code" value="{{$projectSettings->nebim_user_group_code}}">
                    </div>

                    <div class="form-group">
                        <label for="nebim_username">Nebim Username</label>
                        <input type="text" class="form-control" id="nebim_username" name="nebim_username"
                               placeholder="Nebim Username" value="{{$projectSettings->nebim_username}}">
                    </div>
                    <div class="form-group">
                        <label for="nebim_password">Nebim Password</label>
                        <input type="password" class="form-control" id="nebim_password" name="nebim_password"
                               placeholder="Nebim Password" value="{{$projectSettings->nebim_password}}">
                    </div>

                    <div class="form-group">
                        <label for="CompanyCode">Nebim CompanyCode</label>
                        <input type="text" class="form-control" id="CompanyCode" name="CompanyCode"
                               placeholder="CompanyCode" value="{{$projectSettings->CompanyCode}}">
                    </div>

                    <div class="form-group">
                        <label for="CustomerCode">Nebim CustomerCode</label>
                        <input type="text" class="form-control" id="CustomerCode" name="CustomerCode"
                               placeholder="CustomerCode" value="{{$projectSettings->CustomerCode}}">
                    </div>

                    <div class="form-group">
                        <label for="Series">Nebim Series</label>
                        <input type="text" class="form-control" id="Series" name="Series"
                               placeholder="Series" value="{{$projectSettings->Series}}">
                    </div>

                    <div class="form-group">
                        <label for="OfficeCode">Nebim OfficeCode</label>
                        <input type="text" class="form-control" id="OfficeCode" name="OfficeCode"
                               placeholder="OfficeCode" value="{{$projectSettings->OfficeCode}}">
                    </div>

                    <div class="form-group">
                        <label for="StoreCode">Nebim StoreCode</label>
                        <input type="text" class="form-control" id="StoreCode" name="StoreCode"
                               placeholder="StoreCode" value="{{$projectSettings->StoreCode}}">
                    </div>

                    <div class="form-group">
                        <label for="WareHouseCode">Nebim WareHouseCode</label>
                        <input type="text" class="form-control" id="WareHouseCode" name="WareHouseCode"
                               placeholder="WareHouseCode" value="{{$projectSettings->WareHouseCode}}">
                    </div>


                    <div class="form-group">
                        <label for="PaymentCode">Nebim PaymentCode</label>
                        <input type="text" class="form-control" id="PaymentCode" name="PaymentCode"
                               placeholder="PaymentCode" value="{{$projectSettings->PaymentCode}}">
                    </div>

                    <div class="form-group">
                        <label for="CurrencyCode">Nebim CurrencyCode</label>
                        <input type="text" class="form-control" id="CurrencyCode" name="CurrencyCode"
                               placeholder="CurrencyCode" value="{{$projectSettings->CurrencyCode}}">
                    </div>

                    <div class="form-group">
                        <label for="ProductInventory">Nebim ProductInventory</label>
                        <input type="text" class="form-control" id="ProductInventory" name="ProductInventory"
                               placeholder="ProductInventory" value="{{$projectSettings->ProductInventory}}">
                    </div>

                    <div class="form-group">
                        <label for="ProductDetail">Nebim ProductDetail</label>
                        <input type="text" class="form-control" id="ProductDetail" name="ProductDetail"
                               placeholder="ProductDetail" value="{{$projectSettings->ProductDetail}}">
                    </div>

                    <div class="form-group">
                        <label for="order_status_id">Aktarılacak Sipariş Durum No</label>
                        <input type="text" class="form-control" id="order_status_id" name="order_status_id"
                               placeholder="order_status_id" value="{{$projectSettings->order_status_id}}">
                    </div>

                    <div class="form-group">
                        <label for="order_schedule">Sipariş Aktarım Süresi ({{$projectSettings->order_schedule}})</label>
                        <select class="form-control" name="order_schedule">
                            <option
                                value="*/5 * * * *" {{ ($projectSettings->order_schedule =='*/5 * * * *') ? 'selected':'' }}>
                                5 Dakika bir kere
                            </option>
                            <option value="*/15 * * * *" {{ ($projectSettings->order_schedule =='*/15 * * * *') ? 'selected':'' }}>15 Dakika bir kere</option>
                            <option value="*/30 * * * *" {{ ($projectSettings->order_schedule =='*/30 * * * *') ? 'selected':'' }}>30 Dakika bir kere</option>
                            <option value="0 * * * *" {{ ($projectSettings->order_schedule =='0 * * * *') ? 'selected':'' }}>Saatte bir kere</option>
                            <option value="0 */6 * * *" {{ ($projectSettings->order_schedule =='0 */6 * * *') ? 'selected':'' }}>6 Saatte bir kere</option>
                            <option value="0 */12 * * *" {{ ($projectSettings->order_schedule =='0 */12 * * *') ? 'selected':'' }}>12 Saatte bir kere</option>
                            <option value="0 4 * * *" {{ ($projectSettings->order_schedule =='0 4 * * *') ? 'selected':'' }}>Her Gün 04:00</option>
                             <option value="0 5 * * *" {{ ($projectSettings->order_schedule =='0 5 * * *') ? 'selected':'' }}>Her Gün 05:00</option>
                            <option value="0 0 * * *" {{ ($projectSettings->order_schedule =='0 0 * * *') ? 'selected':'' }}>Günde bir kere</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="product_schedule">Ürün Aktarım Süresi ({{$projectSettings->product_schedule}})</label>
                        <select class="form-control" name="product_schedule">
                            <option
                                value="*/5 * * * *" {{ ($projectSettings->product_schedule =='*/5 * * * *') ? 'selected':'' }}>
                                5 Dakika bir kere
                            </option>
                            <option value="*/15 * * * *" {{ ($projectSettings->product_schedule =='*/15 * * * *') ? 'selected':'' }}>15 Dakika bir kere</option>
                            <option value="*/30 * * * *" {{ ($projectSettings->product_schedule =='*/30 * * * *') ? 'selected':'' }}>30 Dakika bir kere</option>
                            <option value="0 * * * *" {{ ($projectSettings->product_schedule =='0 * * * *') ? 'selected':'' }}>Saatte bir kere</option>
                            <option value="0 */6 * * *" {{ ($projectSettings->product_schedule =='0 */6 * * *') ? 'selected':'' }}>6 Saatte bir kere</option>
                            <option value="0 */12 * * *" {{ ($projectSettings->product_schedule =='0 */12 * * *') ? 'selected':'' }}>12 Saatte bir kere</option>
                            <option value="0 4 * * *" {{ ($projectSettings->product_schedule =='0 4 * * *') ? 'selected':'' }}>Her Gün 04:00</option>
                             <option value="0 5 * * *" {{ ($projectSettings->product_schedule =='0 5 * * *') ? 'selected':'' }}>Her Gün 05:00</option>
                            <option value="0 0 * * *" {{ ($projectSettings->product_schedule =='0 0 * * *') ? 'selected':'' }}>Günde bir kere</option>

                        </select>
                    </div>


                    <div class="form-group">
                        <label for="stock_schedule">Stok / Fiyat Aktarım Süresi ({{$projectSettings->stock_schedule}}) </label>
                        <select class="form-control" name="stock_schedule">
                            <option
                                value="*/5 * * * *" {{ ($projectSettings->stock_schedule =='*/5 * * * *') ? 'selected':'' }}>
                                5 Dakika bir kere
                            </option>
                            <option value="*/15 * * * *" {{ ($projectSettings->stock_schedule =='*/15 * * * *') ? 'selected':'' }}>15 Dakika bir kere</option>
                            <option value="*/30 * * * *" {{ ($projectSettings->stock_schedule =='*/30 * * * *') ? 'selected':'' }}>30 Dakika bir kere</option>
                            <option value="0 * * * *" {{ ($projectSettings->stock_schedule =='0 * * * *') ? 'selected':'' }}>Saatte bir kere</option>
                            <option value="0 */6 * * *" {{ ($projectSettings->stock_schedule =='0 */6 * * *') ? 'selected':'' }}>6 Saatte bir kere</option>
                            <option value="0 */12 * * *" {{ ($projectSettings->stock_schedule =='0 */12 * * *') ? 'selected':'' }}>12 Saatte bir kere</option>
                            <option value="0 4 * * *" {{ ($projectSettings->stock_schedule =='0 4 * * *') ? 'selected':'' }}>Her Gün 04:00</option>
                             <option value="0 5 * * *" {{ ($projectSettings->stock_schedule =='0 5 * * *') ? 'selected':'' }}>Her Gün 05:00</option>
                            <option value="0 0 * * *" {{ ($projectSettings->stock_schedule =='0 0 * * *') ? 'selected':'' }}>Günde bir kere</option>
                        </select>
                    </div>

   <div class="form-group">
                        <label for="images_schedule">Resim Kontrol Süresi ( {{$projectSettings->images_schedule}})</label>
                        <select class="form-control" name="images_schedule">
                            <option
                                value="*/5 * * * *" {{ ($projectSettings->images_schedule =='*/5 * * * *') ? 'selected':'' }}>
                                5 Dakika bir kere
                            </option>
                            <option value="*/15 * * * *" {{ ($projectSettings->images_schedule =='*/15 * * * *') ? 'selected':'' }}>15 Dakika bir kere</option>
                            <option value="*/30 * * * *" {{ ($projectSettings->images_schedule =='*/30 * * * *') ? 'selected':'' }}>30 Dakika bir kere</option>
                            <option value="0 * * * *" {{ ($projectSettings->images_schedule =='0 * * * *') ? 'selected':'' }}>Saatte bir kere</option>
                            <option value="0 */6 * * *" {{ ($projectSettings->images_schedule =='0 */6 * * *') ? 'selected':'' }}>6 Saatte bir kere</option>
                            <option value="0 */12 * * *" {{ ($projectSettings->images_schedule =='0 */12 * * *') ? 'selected':'' }}>12 Saatte bir kere</option>
                            <option value="0 4 * * *" {{ ($projectSettings->images_schedule =='0 4 * * *') ? 'selected':'' }}>Her Gün 04:00</option>
                             <option value="0 5 * * *" {{ ($projectSettings->images_schedule =='0 5 * * *') ? 'selected':'' }}>Her Gün 05:00</option>
                            <option value="0 0 * * *" {{ ($projectSettings->images_schedule =='0 0 * * *') ? 'selected':'' }}>Günde bir kere</option>
                        </select>
                    </div>


                </div>
            </div>
            <button type="submit" class="mt-4 btn btn-primary">Güncelle</button>
        </form>

    </div>
@endsection()
