@extends('app')
@section('content')
    <div
        class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{__('site.menugeneldurum')}}</h1>
    </div>

    <div class="row">

        <div class="col-12">

            @foreach($errorList as $error)
                <div class="alert alert-danger" role="alert">
                    {{$error}} projesi mysql bağlantısı hatalı!
                </div>
            @endforeach
        </div>


        <div class="col-lg-3 col-md-6">
            <div class="card mb-4 rounded-3 shadow-sm">
                <div class="card-header py-3">
                    <h4 class="my-0 fw-normal">{{__('site.integrationnumber')}}</h4>
                </div>
                <div class="card-body text-center">
                    <h1 class="card-title pricing-card-title">{{$integrationCount}}</h1>
                    <a href="{{route('integration-add')}}" class="w-100 btn btn-lg btn-outline-primary">{{__('site.addsite')}}</a>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card mb-4 rounded-3 shadow-sm">
                <div class="card-header py-3">
                    <h4 class="my-0 fw-normal">{{__('site.errors')}}</h4>
                </div>
                <div class="card-body text-center">
                    <h1 class="card-title pricing-card-title">{{$errorCount}}</h1>
                    <a href="{{route('logs')}}" class="w-100 btn btn-lg btn-outline-warning">{{__('site.show')}}</a>
                </div>
            </div>
        </div>


        @foreach($projects as $project)
            <div
                class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">{{$project['projectName']}}</h1>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="card mb-4 rounded-3 shadow-sm">
                    <div class="card-header py-3">
                        <h4 class="my-0 fw-normal">{{__('site.products')}}</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="card-title pricing-card-title">{{$project['productCount']}}</h1>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="card mb-4 rounded-3 shadow-sm">
                    <div class="card-header py-3">
                        <h4 class="my-0 fw-normal">{{__('site.orders')}}</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="card-title pricing-card-title">{{$project['orderCount']}}</h1>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="card mb-4 rounded-3 shadow-sm">
                    <div class="card-header py-3">
                        <h4 class="my-0 fw-normal">{{__('site.waitingorders')}}</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="card-title pricing-card-title">{{$project['ordersWaiting']}}</h1>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="card mb-4 rounded-3 shadow-sm">
                    <div class="card-header py-3">
                        <h4 class="my-0 fw-normal">{{__('site.errors')}}</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="card-title pricing-card-title">{{$project['errorCount']}}</h1>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection()
