<?php

namespace App\Services;

use App\Models\OpProduct;
use Illuminate\Support\Str;
use App\Models\ProjectSettings;
use App\Models\OpProductSpecial;
use App\Providers\NebimProvider;
use App\Models\OpProductOptionValue;
use Illuminate\Support\Facades\Config;
use Carbon\Carbon;

class NebimDataService
{
    public function replace_tr($text)
    {
        $text = trim($text);
        $search = array('Ç', 'ç', 'Ğ', 'ğ', 'ı', 'İ', 'Ö', 'ö', 'Ş', 'ş', 'Ü', 'ü', 'd', ' ');
        $replace = array('C', 'C', 'G', 'G', 'I', 'I', 'O', 'O', 'S', 'S', 'U', 'U', 'D', '-');
        $new_text = str_replace($search, $replace, $text);
        return $new_text;
    }


    public function fetchProductFromNebim()
    {
        // Projeye ait ayarları al
        $project = ProjectSettings::first();

        // Log oluştur

        // Projeye özgü veritabanı yapılandırması
        $databaseConfigName = Str::slug($project->project_name);
        Config::set('database.default', $databaseConfigName);

        // Nebim veri sağlayıcısını oluştur
        $nebimProvider = new NebimProvider(
            $project->nebim_url,
            $project->nebim_database_name,
            $project->nebim_user_group_code,
            $project->nebim_username,
            $project->nebim_password
        );

        // Ürün fiyatlarını ve detaylarını al
        $productPrices = $nebimProvider->getProducts($project->ProductDetail);

        // JSON'dan diziye çevir

        // Elde edilen verileri döndür
        return $productPrices;
    }



    public function fetchStockAndPriceFromNebim()
    {
        // Projeye ait ayarları al
        $project = ProjectSettings::first();

        // Log oluştur

        // Projeye özgü veritabanı yapılandırması
        $databaseConfigName = Str::slug($project->project_name);
        Config::set('database.default', $databaseConfigName);

        // Nebim veri sağlayıcısını oluştur
        $nebimProvider = new NebimProvider(
            $project->nebim_url,
            $project->nebim_database_name,
            $project->nebim_user_group_code,
            $project->nebim_username,
            $project->nebim_password
        );

        // Ürün fiyatlarını ve detaylarını al
        $products = $nebimProvider->getStockAndPrices($project->ProductInventory);

        // JSON'dan diziye çevir

        // Elde edilen verileri döndür
        return $products;
    }

    public function updateOpenCartProductOptionValue($Barcode, $inventory, $ItemDim1Code)
    {
        if (empty($ItemDim1Code)) {
            $opProduct = OpProduct::where('ean', $Barcode)->first();
            if ($opProduct) {
                OpProduct::where('product_id', $opProduct->product_id)->update([
                    'quantity' => $inventory,
                ]);
            }
        } else {
            $opProductOptionValue = OpProductOptionValue::where('ean', $Barcode)->first();
            if ($opProductOptionValue) {
                OpProductOptionValue::where('product_option_value_id', $opProductOptionValue->product_option_value_id)->update([
                    'quantity' => $inventory,
                ]);
            }
        }

    }


    public function updatePrice($Barcode, $Price1, $Price2)
    {
        // Mass assignment korumasını kaldır
        OpProduct::unguard();
        OpProductSpecial::unguard();

        // Ürünü SKU'ya göre bul
        $opProduct = OpProduct::where('ean', $Barcode)->first();

        if ($opProduct) {
            // Eğer Price2 varsa, ürünün ana fiyatını güncelle (Price2, üstü çizik fiyat)
            if ($Price2 > 0) {
                OpProduct::where('ean', $Barcode)->update(['price' => $Price2]);

                // Eğer Price1 varsa, special price tablosundaki ilgili kaydı güncelle veya oluştur
                if ($Price1 > 0) {
                    $specialPrice = OpProductSpecial::where('product_id', $opProduct->product_id)->first();

                    if ($specialPrice) {
                        OpProductSpecial::where('product_id', $opProduct->product_id)->update([
                            'customer_group_id' => 1,
                            'priority' => 0,
                            'price' => $Price1,
                            'date_start' => Carbon::createFromFormat('d.m.Y', '01.01.2024'),
                            'date_end' => Carbon::createFromFormat('d.m.Y', '01.01.2099')
                        ]);
                    } else {
                        $newOpProductSpecial = new OpProductSpecial();
                        $newOpProductSpecial->product_id = $opProduct->product_id;
                        $newOpProductSpecial->customer_group_id = "1";
                        $newOpProductSpecial->priority = "0";
                        $newOpProductSpecial->price = floatval($Price1);
                        $newOpProductSpecial->date_start = Carbon::parse("1975-01-01")->format('Y-m-d');
                        $newOpProductSpecial->date_end = Carbon::parse("2025-01-01")->format('Y-m-d');
                        $newOpProductSpecial->save();



                    }
                } else {
                    // Eğer Price1 yoksa, special price tablosundan ilgili kaydı sil
                    OpProductSpecial::where('product_id', $opProduct->product_id)->delete();
                }
            } else {
                // Eğer Price2 yoksa, ürünün ana fiyatını Price1 olarak güncelle
                OpProduct::where('ean', $Barcode)->update(['price' => $Price1]);

                // Price2 yoksa, special price tablosundaki ilgili kaydı sil
                OpProductSpecial::where('product_id', $opProduct->product_id)->delete();
            }
        }

        // Mass assignment korumasını tekrar etkinleştir
        OpProduct::reguard();
        OpProductSpecial::reguard();
    }







}
