<?php

namespace App\Providers;

use Illuminate\Support\Facades\Http;


class NebimProvider
{

    private $providerUrl;
    private $databaseName;
    private $userGroupCode;
    private $username;
    private $password;
    public $sessionId;

    public function __construct($providerUrl, $databaseName, $userGroupCode, $username, $password)
    {

        $this->providerUrl = $providerUrl;
        $this->databaseName = $databaseName;
        $this->userGroupCode = $userGroupCode;
        $this->username = $username;
        $this->password = $password;


        $response = Http::withHeaders([
            'Content-Type' => 'text/plain'
        ])->post($this->providerUrl . '/IntegratorService/Connect', [
            "ModelType" => 1,
            "DatabaseName" => $this->databaseName,
            "UserGroupCode" => $this->userGroupCode,
            "UserName" => $this->username,
            "Password" => $this->password
        ])->json();

        if ($response['StatusCode'] == 200) {
            $this->sessionId = $response['SessionID'];
        } else {
            throw new Exception("Connection error.");
        }
    }

    public function getStockAndPrices($productInventory)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'text/plain'
        ])->get($this->providerUrl . '/(S(' . $this->sessionId . '))/Integratorservice/RunProc?{%20%22ProcName%22:%20%22' . $productInventory . '%22,%20%22Parameters%22:%20[%20{%20%22Name%22:%20%22LastNDay%22,%20%22Value%22:%20%225000%22%20},%20{%20%22Name%22:%20%22LangCode%22,%20%22Value%22:%20%22TR%22%20}%20]%20}');
        return $response->json();
    }

    public function getProducts($productDetail)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'text/plain'
        ])->get($this->providerUrl . '/(S(' . $this->sessionId . '))/Integratorservice/RunProc?{%22ProcName%22:%22usp_' . $productDetail . '%22,%22Parameters%22:[{%22Name%22:%20%22LastNDay%22,%22Value%22:%225000%22},{%20%22Name%22:%22LangCode%22,%22Value%22:%22TR%22}]}');

        return $response->body();
    }

    public function getAccountByEmail($email)
    {
        $response = Http::post($this->providerUrl . '/(S(' . $this->sessionId . '))/Integratorservice/RunProc?',
            [
                "ProcName" => "sp_FindCustomerAYAYDIN",
                "Parameters" => [
                    [
                        "Name" => "EMail",
                        "Value" => $email
                    ]
                ]
            ]);
        return $response->json();
    }

    public function createAccount($firstname, $lastname, $email, $OfficeCode)
    {
        $response = Http::post($this->providerUrl . '/(S(' . $this->sessionId . '))/Integratorservice/POST/',
            [
                "ModelType" => 3,
                "CurrAccCode" => "",
                "FirstName" => $firstname,
                "LastName" => $lastname,
                "IdentityNum" => "11111111111",
                "IsIndividualAcc" => true,
                "CurrAccDescription" => "",
                "TaxNumber" => "",
                "OfficeCode" => $OfficeCode,
                "TaxOfficeCode" => "",
                "PostalAddresses" => [
                    ["AddressTypeCode" => "1",
                        "Address" => "",
                        "CountryCode" => "RS",
                        "StateCode" => "RS.RS",
                        "CityCode" => "RS.RS",
                        "DistrictCode" => "RS.RS",
                        "TaxNumber" => "",
                        "TaxOfficeCode" => "",
                        "DoorNum" => 10
                    ],
                ],
                "Communications" => [
                    ["CommunicationTypeCode" => "3",
                        "CommAddress" => $email,
                        "CanSendAdvert" => true
                    ]
                ]
            ]);
        return $response->json();
    }

    public function createOrder($site, $customerCode, $OfficeCode, $StoreCode, $WareHouseCode, $description, $lines, $paymentType, $paymentCode, $currencyCode, $paymentCreditCartTypeCode, $priceFix, $discountAmount, $CompanyCode, $Series)
    {
        $date = date('d.m.Y H:i:s');
        $orderData = [
            "ModelType" => 8,
            "InvoiceNumber" => "",
            "CompanyCode" => $CompanyCode,
            "CustomerCode" => $customerCode,
            "DeliveryCompanyCode" => "",
            "Description" => "",
            "EMailAddress" => "",
            "Series" => $Series,
            "SeriesNumber" => $description,
            "InternalDescription" => "",
            "DocCurrencyCode" => "$currencyCode",
            "InvoiceDate" => $date,
            "IsCompleted" => true,
            "IsSalesViaInternet" => true,
            "Lines" => $lines,
            "OfficeCode" => "$OfficeCode",
            "PosTerminalID" => 1,
            "SalesViaInternetInfo" => [
                "PaymentAgent" => "",
                "PaymentDate" => $date,
                "PaymentTypeCode" => 1,
                "PaymentTypeDescription" => "DIGER",
                "SalesURL" => $site,
                "SendDate" => $date,
                "SendTime" => null
            ],
            "SendInvoiceByEMail" => false,
            "ApplyCampaign" => false,
            "ShipmentMethodCode" => 2,
            "StoreCode" => "$StoreCode",
            "WarehouseCode" => "$WareHouseCode",
            "Payments" => [
                [
                    "PaymentType" => 2,
                    "Code" => "",
                    "CreditCardTypeCode" => "OP",
                    "InstallmentCount" => 1,
                    "CurrencyCode" => "$currencyCode",
                    "DocCurrencyCode" => "$currencyCode",
                    "Amount" => $priceFix
                ]
            ],
            "Discounts" => [
                [
                    "DiscountTypeCode" => 5,
                    "Value" => $discountAmount,
                    "IsPercentage" => false
                ]
            ]
        ];


        echo json_encode($orderData);

        $response = Http::post($this->providerUrl . '/(S(' . $this->sessionId . '))/Integratorservice/POST/', $orderData);

        return $response->json();
    }


}
