<?php

namespace App\Providers;

use App\Models\ProjectSettings;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;
use League\Flysystem\Config;
use Illuminate\Pagination\Paginator;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        ini_set("serialize_precision",-1);
        Paginator::useBootstrap();
        if (! app()->runningInConsole()) {$projectSettings = ProjectSettings::all();
            foreach ($projectSettings as $project) {
                config()->set('database.connections.' . Str::slug($project->project_name), [
                    'driver' => 'mysql',
                    'url' => null,
                    'host' => $project->database_host,
                    'port' => $project->database_port,
                    'database' => $project->database_name,
                    'username' => $project->database_username,
                    'password' => $project->database_password,
                    'unix_socket' => null,
                    'charset' => 'utf8mb4',
                    'collation' => 'utf8mb4_unicode_ci',
                    'prefix' => null,
                    'prefix_indexes' => 1,
                    'strict' => 1,
                    'engine' => null,
                    'options' => [],
                ]);

                config()->set('nebim.' . Str::slug($project->project_name), [
                    'nebim_url' => $project->nebim_url,
                    'nebim_database_name' => $project->nebim_database_name,
                    'nebim_user_group_code' => $project->nebim_user_group_code,
                    'nebim_username' => $project->nebim_username,
                    'nebim_password' => $project->nebim_password,
                ]);
            }
        }




    }
}
