<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectSettings extends Model {
	use HasFactory;

	protected $fillable = ['project_name', 'database_host', 'database_port', 'database_name', 'database_username', 'database_password', 'nebim_url', 'nebim_database_name', 'nebim_user_group_code', 'nebim_username', 'nebim_password', 'order_schedule', 'product_schedule', 'stock_schedule', 'order_status_id', 'OfficeCode', 'StoreCode', 'WareHouseCode', 'PaymentCode', 'CurrencyCode', 'ProductInventory', 'ProductDetail', 'CompanyCode', 'CustomerCode', 'Series', 'images_schedule'];
	protected $connection = 'main';

	public static function getProjectName($id) {
		$project = ProjectSettings::where('id', $id)->first();

		if ($project) {
			return $project->project_name;
		} else {
			return "Bilinmiyor";
		}
	}
}
