<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OpProduct extends Model {
	use HasFactory;
	protected $table = 'oc_product';
	public $timestamps = false;

	public function integrationstok() {
		return $this->hasMany('App\Models\IntegrationProductStocks', 'Barcode', 'ean');
	}
	public function integration() {
		return $this->hasOne('App\Models\IntegrationProducts', 'StockCode', 'model');
	}
	public function integrations() {
		return $this->HasMany('App\Models\IntegrationProducts', 'StockCode', 'model');
	}
	public function special() {
		return $this->hasMany('App\Models\OpProductSpecial', 'product_id', 'product_id');
	}
	public function images() {
		return $this->hasMany('App\Models\OpProductImage', 'product_id', 'product_id');
	}

}
