<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Logs extends Model
{
    use HasFactory;

    protected $connection = 'main';


    public static function createLog($integrationId, $message, $error)
    {
        $log = new Logs();
        $log->integrationId = $integrationId;
        $log->message = $message;
        $log->has_error = $error;
        $log->save();

        $oldLogs = Logs::where('created_at', '<', now()->subDay())->get();
        foreach ($oldLogs as $oldLog) {
            $oldLog->delete();
        }

    }


}
