<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProjectSettingsEditRequest;
use App\Http\Requests\ProjectSettingsRequest;
use App\Models\Logs;
use App\Models\ProjectSettings;
use App\Services\NebimDataService;
use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TestController extends Controller
{

    public function testStokPriceService()
    {
        try {

            $nebimService = new NebimDataService();

            // 1.Servisten fiyatları getir.

            $stockList = $nebimService->fetchStockAndPriceFromNebim();

            foreach ($stockList as $stock) {
                $nebimService->updateOpenCartProductOptionValue($stock['Barcode'], $stock['Inventory'], $stock['ItemDim1Code']);
                $nebimService->updatePrice($stock['Barcode'], $stock['Price1'], $stock['Price2']);
            }




            return $stockList;
        } catch (\Exception $e) {
            // Hata oluştuğunda bu blok çalışır
            // Loglama yapabilir veya uygun bir hata mesajı döndürebilirsiniz
            return response()->json(['error' => 'Servis çağrısı sırasında bir hata oluştu: ' . $e->getMessage()], 500);
        }
    }

}
