<?php

namespace App\Http\Controllers;

use App\Models\OpOrder;
use App\Models\OpProduct;
use App\Models\OpProductSpecial;
use App\Models\ProjectSettings;
use Config;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class OpController extends Controller {

	public function products(Request $request) {
		$projects = ProjectSettings::all();
		if (!intval($request->project)) {
			$products = [];
			$total = 0;
			$currentProject = 0;
		} else {
			$selectedProject = ProjectSettings::find($request->project);
			$databaseConfigName = Str::slug($selectedProject->project_name);
			Config::set('database.default', $databaseConfigName);

			$products = OpProduct::select('*');

			if ($request->image == 1) {
				$products = $products->whereRaw('LENGTH(image) > ?', [1]);
			} elseif ($request->image == 2) {
				$products = $products->where('image', '')->where('quantity', '>', 0);
			}

			if ($request->model) {
				$products = $products->where('model', 'like', '%' . $request->model . '%');
			}
			if ($request->sku) {
				$products = $products->where('sku', 'like', '%' . $request->sku . '%');
			}
			if ($request->ean) {
				$products = $products->where('ean', 'like', '%' . $request->ean . '%');
			}

			$products = $products->orderBy('product_id', 'desc')->with('special', 'integration', 'integration.stock', 'integrationstok', 'images')->paginate(100)->appends(request()->query());

			$totalStock = OpProduct::selectRaw('sum(quantity) as totalStock')->first();
			$total = $totalStock->totalStock;
			$currentProject = $selectedProject->id;
		}

		return view('products', ['projects' => $projects, 'products' => $products, 'totalStock' => $total, 'currentProject' => $currentProject]);
	}

	public function orders(Request $request) {
		$projects = ProjectSettings::all();
		if (!intval($request->project)) {
			$orders = [];
			$currentProject = 0;
		} else {
			$selectedProject = ProjectSettings::find($request->project);
			$databaseConfigName = Str::slug($selectedProject->project_name);
			Config::set('database.default', $databaseConfigName);

			$orders = OpOrder::where('order_status_id', '>', 0)->orderBy('order_id', 'DESC');

			if ($request->nebim == 1) {
				$orders = $orders->where('nebim', '=', 1);
			} elseif ($request->nebim == 2) {
				$orders = $orders->where('nebim', '=', 0);
			}

			if ($request->order_id) {
				$orders = $orders->where('order_id', $request->order_id);
			}

			$orders = $orders->paginate()->appends(request()->query());

			$currentProject = $selectedProject->id;

		}

		return view('orders', ['projects' => $projects, 'orders' => $orders, 'currentProject' => $currentProject]);
	}
	public function getPriceUpdate(Request $request) {
		$projects = ProjectSettings::all();
		if (!intval($request->id)) {
			$products = [];
			$total = 0;
			$currentProject = 0;
		} else {
			$selectedProject = ProjectSettings::find($request->id);
			$databaseConfigName = Str::slug($selectedProject->project_name);
			Config::set('database.default', $databaseConfigName);

			$products = OpProduct::with('integration', 'special')->get();

			$data = array();

			foreach ($products as $product) {

				if ($product->price > 0) {
					if ($product->special->first() == TRUE) {

						if ($product->special->first()->price > 0) {

							$findspecial = OpProductSpecial::where('product_id', $product->product_id)->first();

							if ($product->integration == TRUE) {

								if ($product->integration->Price1 > 0) {
									$findagan = OpProductSpecial::where('product_special_id', $findspecial->product_special_id)->update(array('price' => $product->integration->Price1));

								}
								if ($product->integration->Price2 == 0) {
									$findagan = OpProductSpecial::where('product_special_id', $findspecial->product_special_id)->delete();
									$updateproduct = OpProduct::where('model', $product->model)->update([
										'price' => $product->integration->Price1,
									]);

								}

							} else {
								//	$findagan = OpProductSpecial::where('product_special_id', $findspecial->product_special_id)->delete();

							}

						}

					}
				}

			}

		}
	}
}
