<?php

namespace App\Http\Controllers;

use App\Models\Logs;
use Illuminate\Http\Request;

class LogsController extends Controller
{
    public function list(Request $request)
    {
        $logs = Logs::orderBy('created_at', 'DESC');

        if ($request->has_error == 1) {
            $logs = $logs->where('has_error', 1);
        }

        $logs = $logs->paginate()->appends(request()->query());

        return view('logs', ['logs' => $logs]);
    }

    public function get($id)
    {
        $log = Logs::where('id', $id)->first();

        return view('log', ['log' => $log]);
    }

    public function logsDelete(){
        Logs::query()->delete();
        return redirect()->back();
    }
}
