<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProjectSettingsEditRequest;
use App\Http\Requests\ProjectSettingsRequest;
use App\Models\ProjectSettings;
use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\Logs;
use App\Services\NebimDataService;

class IntegrationController extends Controller {
	public function list() {
		$projectSettings = ProjectSettings::all();
		return view('integrations', ['projectSettings' => $projectSettings]);
	}

	public function create(ProjectSettingsRequest $request) {
		$projectSettings = ProjectSettings::create($request->all());
		Logs::createLog($projectSettings->id, "Proje oluşturuldu", 0);

		config()->set('database.connections.' . Str::slug($projectSettings->project_name), [
			'driver' => 'mysql',
			'url' => null,
			'host' => $projectSettings->database_host,
			'port' => $projectSettings->database_port,
			'database' => $projectSettings->database_name,
			'username' => $projectSettings->database_username,
			'password' => $projectSettings->database_password,
			'unix_socket' => null,
			'charset' => 'utf8mb4',
			'collation' => 'utf8mb4_unicode_ci',
			'prefix' => null,
			'prefix_indexes' => 1,
			'strict' => 1,
			'engine' => null,
			'options' => [],
		]);

		$databaseConfigName = Str::slug($projectSettings->project_name);
		Config::set('database.default', $databaseConfigName);

		try {
			DB::statement("ALTER TABLE oc_order ADD COLUMN nebim INT(11) DEFAULT 0;");
		} catch (\Exception $e) {
		}

		try {
			DB::statement("DROP TABLE oc_attribute;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_attribute_description;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_attribute_group;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_attribute_group_description;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_category;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_category_description;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_manufacturer;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_manufacturer_to_store;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_option;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_option_description;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_option_value;");
		} catch (\Exception $e) {
		}
		try {
			DB::statement("DROP TABLE oc_option_value_description;");
		} catch (\Exception $e) {
		}

		DB::statement("CREATE TABLE `oc_attribute` (
          `attribute_id` int(11) NOT NULL,
          `attribute_group_id` int(11) NOT NULL,
          `sort_order` int(3) NOT NULL
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;");

		DB::statement("INSERT INTO `oc_attribute` (`attribute_id`, `attribute_group_id`, `sort_order`) VALUES (47, 11, 0),
                            (43, 11, 9),
                            (42, 11, 8),
                            (41, 11, 8),
                            (40, 11, 7),
                            (39, 11, 6),
                            (38, 11, 5),
                            (37, 11, 4),
                            (36, 11, 3),
                            (46, 11, -1),
                            (44, 11, 10),
                            (48, 11, 0),
                            (35, 11, 2),
                            (51, 11, 0),
                            (34, 11, 1),
                            (49, 11, 0),
                            (45, 11, 11),
                            (50, 11, 0);");
		DB::statement("CREATE TABLE `oc_attribute_description` (
                              `attribute_id` int(11) NOT NULL,
                              `language_id` int(11) NOT NULL,
                              `name` varchar(64) NOT NULL
                            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;");

		DB::statement("INSERT INTO `oc_attribute_description` (`attribute_id`, `language_id`, `name`) VALUES
(49, 1, 'DODATNE MOGUĆNOSTI'),
(46, 1, 'BOJA'),
(44, 1, 'Paket Məzmunu'),
(45, 1, 'Parça Növü'),
(50, 1, 'DODATNE MOGUĆNOSTI'),
(35, 1, 'FIT'),
(36, 1, 'DEZEN'),
(37, 1, 'VRSTA KRAGNE'),
(47, 1, 'VELIČINA'),
(38, 1, 'RUKAV'),
(34, 1, 'PROIZVOD'),
(48, 1, 'VELIČINA'),
(39, 1, 'MATERIJAL'),
(40, 1, 'Manşet Modeli'),
(41, 1, 'VRSTA DŽEPA'),
(42, 1, 'STIL'),
(43, 1, 'SEZONA'),
(51, 1, 'VRSTA MATERIJALA');");

		DB::statement("CREATE TABLE `oc_attribute_group` (
  `attribute_group_id` int(11) NOT NULL,
  `sort_order` int(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");

		DB::statement("INSERT INTO `oc_attribute_group` (`attribute_group_id`, `sort_order`) VALUES
(11, 0);");

		DB::statement("CREATE TABLE `oc_attribute_group_description` (
  `attribute_group_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");

		DB::statement("INSERT INTO `oc_attribute_group_description` (`attribute_group_id`, `language_id`, `name`) VALUES
(11, 1, 'Opis proizvoda');");

		DB::statement("ALTER TABLE `oc_attribute`
  ADD PRIMARY KEY (`attribute_id`);");

		DB::statement("ALTER TABLE `oc_attribute_description`
  ADD PRIMARY KEY (`attribute_id`,`language_id`);");

		DB::statement("ALTER TABLE `oc_attribute_group`
  ADD PRIMARY KEY (`attribute_group_id`);");

		DB::statement("ALTER TABLE `oc_attribute_group_description`
  ADD PRIMARY KEY (`attribute_group_id`,`language_id`);");

		DB::statement("ALTER TABLE `oc_attribute`
  MODIFY `attribute_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=52;
");
		DB::statement("ALTER TABLE `oc_attribute_group`
  MODIFY `attribute_group_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;");
		DB::statement("CREATE TABLE `oc_category` (
  `category_id` int(11) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `top` tinyint(1) NOT NULL,
  `column` int(3) NOT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `nebim_cat_code` varchar(255) NOT NULL,
  `nebim_cat_code2` varchar(255) NOT NULL,
  `code` varchar(64) DEFAULT NULL,
  `google_merchant_id` int(11) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("INSERT INTO `oc_category` (`category_id`, `image`, `parent_id`, `top`, `column`, `sort_order`, `status`, `date_added`, `date_modified`, `nebim_cat_code`, `nebim_cat_code2`, `code`, `google_merchant_id`) VALUES
(1, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '06', '0', NULL, 176),
(2, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '16', '0', NULL, 209),
(3, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '30', '0', NULL, 179),
(4, '', 0, 0, 1, 1, 1, '2022-02-16 11:54:09', '2022-02-16 14:55:33', '02', '0', NULL, 212),
(5, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '31', '0', NULL, 167),
(6, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '44', '0', NULL, 212),
(7, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '41', '0', NULL, 212),
(8, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '07', '0', NULL, 177),
(9, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '28', '0', NULL, 173),
(10, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '09', '0', NULL, 173),
(11, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '37', '0', NULL, 212),
(12, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '22', '0', NULL, 169),
(13, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '10', '0', NULL, 1893),
(14, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '11', '0', NULL, 2562),
(15, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '19', '0', NULL, 170),
(16, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '33', '0', NULL, 173),
(17, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '34', '0', NULL, 207),
(18, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '15', '0', NULL, 3032),
(19, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '03', '0', NULL, 212),
(20, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '13', '0', NULL, 5207),
(21, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '14', '0', NULL, 2668),
(22, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '21', '0', NULL, 0),
(23, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '42', '0', NULL, 212),
(24, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '05', '0', NULL, 212),
(25, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '43', '0', NULL, 212),
(26, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '23', '0', NULL, 193),
(27, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '27', '0', NULL, 180),
(28, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '32', '0', NULL, 479),
(29, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '36', '0', NULL, 6984),
(30, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '20', '0', NULL, 178),
(31, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '25', '0', NULL, 479),
(32, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '26', '0', NULL, 196),
(33, '', 0, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-06-29 17:06:29', '38', '0', NULL, 200),
(34, '', 1, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-06-01 13:47:39', '06', '07', NULL, 176),
(35, '', 1, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-06-01 13:48:17', '06', '08', NULL, 176),
(36, '', 4, 0, 1, 20, 1, '2022-02-16 11:54:09', '2022-06-29 17:15:06', '02', '01', NULL, 212),
(37, '', 6, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '44', '01', NULL, 212),
(38, '', 4, 0, 1, 60, 1, '2022-02-16 11:54:09', '2022-06-29 17:15:54', '02', '05', NULL, 212),
(39, '', 4, 0, 1, 40, 1, '2022-02-16 11:54:09', '2022-06-29 17:15:27', '02', '02', NULL, 212),
(40, '', 7, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '41', '01', NULL, 212),
(41, '', 4, 0, 1, 30, 1, '2022-02-16 11:54:09', '2022-06-29 17:14:34', '02', '04', NULL, 212),
(42, '', 11, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '37', '01', NULL, 212),
(43, '', 19, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '03', '01', NULL, 212),
(44, '', 4, 0, 1, 10, 1, '2022-02-16 11:54:09', '2022-06-29 17:14:08', '02', '03', NULL, 212),
(45, '', 19, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '03', '06', NULL, 212),
(46, '', 23, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '42', '01', NULL, 212),
(47, '', 4, 0, 1, 50, 1, '2022-02-16 11:54:09', '2022-06-29 17:16:16', '02', '06', NULL, 212),
(48, '', 99, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '45', '01', NULL, 0),
(49, '', 24, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '05', '01', NULL, 212),
(50, '', 19, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '03', '02', NULL, 212),
(51, '', 25, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '43', '01', NULL, 212),
(52, '', 19, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '03', '05', NULL, 212),
(53, '', 7, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '41', '02', NULL, 212),
(54, '', 23, 0, 1, 0, 1, '2022-02-16 11:54:09', '2022-02-16 11:54:09', '42', '02', NULL, 212),
(55, '', 0, 0, 1, 0, 1, '2022-02-16 14:14:15', '2022-02-16 14:14:15', '', '', NULL, 0);");
		DB::statement("CREATE TABLE `oc_category_description` (
  `category_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_description` varchar(255) NOT NULL,
  `meta_keyword` varchar(255) NOT NULL,
  `seo_keyword` varchar(255) NOT NULL,
  `seo_h1` varchar(255) NOT NULL,
  `seo_h2` varchar(255) NOT NULL,
  `seo_h3` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("
INSERT INTO `oc_category_description` (`category_id`, `language_id`, `name`, `description`, `meta_title`, `meta_description`, `meta_keyword`, `seo_keyword`, `seo_h1`, `seo_h2`, `seo_h3`) VALUES
(1, 1, 'Kravate', 'Kolekcija kravata različitih boja biće savršen dodatak vašem stilu. Istaknite ga sa Tudors dodacima. Otkrijte dizajn muških kravata sa popustima do 70%!', 'Kolekcija kravata | TUDORS', 'Kolekcija kravata različitih boja biće savršen dodatak vašem stilu. Istaknite ga sa Tudors dodacima. Otkrijte dizajn muških kravata sa popustima do 70%!', 'Kravata,', '', '', '', ''),
(2, 1, 'Čarape', 'Kolekcija najboljih muških čarapa nalazi se u Tudors-u. Muške čarape po pristupačnoj ceni čekaju vas uz bezbedno iskustvo kupovine online.', 'Muške čarape  | TUDORS', 'Kolekcija najboljih muških čarapa nalazi se u Tudors-u. Muške čarape po pristupačnoj ceni čekaju vas uz bezbedno iskustvo kupovine online.', 'Čarape,', '', '', '', ''),
(3, 1, 'Tregeri', 'Tudors kolekcija muških tregera sa pristupačnim cenama i brzom isporukom. Otkrijte kolekciju tegera.', 'Tregeri | TUDORS', 'Tudors kolekcija muških tregera sa pristupačnim cenama i brzom isporukom. Otkrijte kolekciju tegera.', 'Tregeri,', '', '', '', ''),
(4, 1, 'Košulja', 'Stilizovane muške košulje, dizajnirane u Turskoj i Italiji su u Tudursu sa cenama posebno sniženim samo za vas! Istraži kolekciju  muških košulja i poručite online sa do 70% popusta.', 'Muške košulje | TUDORS', 'Stilizovane muške košulje, dizajnirane u Turskoj i Italiji su u Tudursu sa cenama posebno sniženim samo za vas! Istraži kolekciju  muških košulja i poručite online sa do 70% popusta.', 'Košulja,', '', '', '', ''),
(5, 1, 'Leptir mašne', 'Neverovatna kolekcija muških leptir mašni po pristupačnim cenama! Kliknite sada kako biste videli najnoviji dizajn muških leptir mašni i upotpunite svoj izgled sa stilom.', 'Kolekcija leptir mašni  | TUDORS', 'Neverovatna kolekcija muških leptir mašni po pristupačnim cenama! Kliknite sada kako biste videli najnoviji dizajn muških leptir mašni i upotpunite svoj izgled sa stilom.', 'Leptir mašna,', '', '', '', ''),
(6, 1, 'Pleteni prsluk', '', 'Pleteni prsluk', 'Pleteni prsluk', 'Pleteni prsluk,', '', '', '', ''),
(7, 1, 'Kardigani', 'Vanvremenska kolekcija muških kardigana u Tudors-u po  sniženim cenama! Poručite još danas neki od muških džempera na rasprodaji!', 'Muška kolekcija kardigana | TUDORS', 'Vanvremenska kolekcija muških kardigana u Tudors-u po  sniženim cenama! Poručite još danas neki od muških džempera na rasprodaji!', 'Kardigani,', '', '', '', ''),
(8, 1, 'Šalovi', 'Kolekcija muških šalova je u Tudors-u sa specijalnim ponudama i sniženim cenama. Tudors šal  će upotpuniti vašu kombinaciju rukavica i kape.', 'Kolekcija muških šaleva  | TUDORS', 'Kolekcija muških šalova je u Tudors-u sa specijalnim ponudama i sniženim cenama. Tudors šal  će upotpuniti vašu kombinaciju rukavica i kape.', 'Šalovi,', '', '', '', ''),
(9, 1, 'Štitnik za uši', '', 'Štitnik za uši', 'Štitnik za uši', 'Štitnik za uši,', '', '', '', ''),
(10, 1, 'Kape', 'Najbolja kolekcija muških kapa sa garantovano najboljim cenama svakog dana u godini nalazi se u Tudors! Kliknite da kupite odmah!', 'Kolekcija muških kapa  | TUDORS', 'Najbolja kolekcija muških kapa sa garantovano najboljim cenama svakog dana u godini nalazi se u Tudors! Kliknite da kupite odmah!', 'Kape,', '', '', '', ''),
(11, 1, 'Prsluci', 'Predstavljamo najsvežiju kolekciju u kategoriji muških prsluka koja će vašem izgledu dodati moderan pečat. Kupujte sada i ne propustite pristupačne cene i promotivne ponude!', 'Kolekcija muških prsluka  | TUDORS', 'Predstavljamo najsvežiju kolekciju u kategoriji muških prsluka koja će vašem izgledu dodati moderan pečat. Kupujte sada i ne propustite pristupačne cene i promotivne ponude!', 'Prsluci,', '', '', '', ''),
(12, 1, 'Kaiševi', 'Moderna kolekcija muških kaiševa u Tudors-u sa popustima od 30%. Kliknite da pogledate najnoviji trendove kod muških kaiševa i lako pronađite svoj!', 'Kolekcija muških kaiševa | TUDORS', 'Moderna kolekcija muških kaiševa u Tudors-u sa popustima od 30%. Kliknite da pogledate najnoviji trendove kod muških kaiševa i lako pronađite svoj!', 'Kaiševi,', '', '', '', ''),
(13, 1, 'Narukvice', 'Tudors muške narukvice za savršen izgled. Veliki izbor materijala i boja garantuje da ćete pronači onu pravu. Brza i sigurna isporuka.', 'Kolekcija muških narukvica | TUDORS', 'Tudors muške narukvice za savršen izgled. Veliki izbor materijala i boja garantuje da ćete pronači onu pravu. Brza i sigurna isporuka.', 'Narukvice,', '', '', '', ''),
(14, 1, 'Donji veš', 'Kolekcija muškog donjeg veša i specijalne cene samo na Tudors-u. Istražite ponudu donjeg veša i poručite online uz popuste i do 70%.', 'Kolekcija donjeg veša  | TUDORS', 'Kolekcija muškog donjeg veša i specijalne cene samo na Tudors-u. Istražite ponudu donjeg veša i poručite online uz popuste i do 70%.', 'Donji veš,', '', '', '', ''),
(15, 1, 'Rukavice', 'Omiljena kolekcija muških rukavica odabrana je po svom šik i upadljivom stilu tokom zime. Ne čekajte zimu i poručite odmah!', 'Rukavice | TUDORS', 'Omiljena kolekcija muških rukavica odabrana je po svom šik i upadljivom stilu tokom zime. Ne čekajte zimu i poručite odmah!', 'Rukavice,', '', '', '', ''),
(16, 1, 'Šešir', '', 'Šešir', 'Šešir', 'Šešir,', '', '', '', ''),
(17, 1, 'Šortsevi', 'Izaberite najudobniji muški šorts za kupanje u moru dezena. Uživajte u letu!', 'Muški šortsevi  | TUDORS', 'Izaberite najudobniji muški šorts za kupanje u moru dezena. Uživajte u letu!', 'Šortsevi,', '', '', '', ''),
(18, 1, 'Torbe', 'Tudors elegantne muške torbe koje odgovaraju svakom stilu i poručite online pre isteka zaliha!', 'Kolekcija muških torbi  | TUDORS', 'Tudors elegantne muške torbe koje odgovaraju svakom stilu i poručite online pre isteka zaliha!', 'Torbe,', '', '', '', ''),
(19, 1, 'Majice', 'Kolekcija muških majica u Tudors-u po najpovoljnijim cenama! Otkrijte jednobojne, sa šarom ili teksturom, moderne muške majice sa V ili O izrezom.  U ponudi imamo i muške polo majice sa kragnom. Novi dizajni svakodnevno!', 'Kolekcija muških majica  | TUDORS', 'Kolekcija muških majica u Tudors-u po najpovoljnijim cenama! Otkrijte jednobojne, sa šarom ili teksturom, moderne muške majice sa V ili O izrezom.  U ponudi imamo i muške polo majice sa kragnom. Novi dizajni svakodnevno!', 'Majice,', '', '', '', ''),
(20, 1, 'Džepne maramice', 'Za sve muškarce koji cene svoj stil, veliki izbor džepnih maramica. Tudors aksesoari za svaku priliku.', 'Kolekcija džepnih maramica | TUDORS', 'Za sve muškarce koji cene svoj stil, veliki izbor džepnih maramica. Tudors aksesoari za svaku priliku.', 'Džepne maramice,', '', '', '', ''),
(21, 1, 'Novčanici', 'Kolekcija muških novčanika vas čeka sa specijalnom ponudom.', 'Muški novčanici  | TUDORS', 'Kolekcija muških novčanika vas čeka sa specijalnom ponudom.', 'Novčanici,', '', '', '', ''),
(22, 1, 'Poklon set', '', 'Poklon set', 'Poklon set', 'Poklon set,', '', '', '', ''),
(23, 1, 'Džemperi', 'Kolekcija muških džempera pažljivo kreirana za zimsku sezonu koja će vas zagrejati.', 'Muška kolekcija džempera I TUDORS', 'Kolekcija muških džempera pažljivo kreirana za zimsku sezonu koja će vas zagrejati.', 'Džemperi,', '', '', '', ''),
(24, 1, 'Duksevi', 'Centar vašeg izgleda Tudors duksevi. Pokrivajući ceo gornji deo tela, izdvajaće se od vaše druge odeće. Proverite sada najbolje ponude i brzu isporuku.', 'Kolekcija muških dukseva  | TUDORS', 'Centar vašeg izgleda Tudors duksevi. Pokrivajući ceo gornji deo tela, izdvajaće se od vaše druge odeće. Proverite sada najbolje ponude i brzu isporuku.', 'Duksevi,', '', '', '', ''),
(25, 1, 'Džemperi bez rukava', 'Jedinstvena kolekcija džempera sa V izrezom savršena i za elegantan i za sportski stil oblačenja je samo jedan klik od vas. Najbolje tkanine visokog kvaliteta samo u Tudors asortimanu.', 'Kolekcija muških džempera bez rukava | TUDORS', 'Jedinstvena kolekcija džempera sa V izrezom savršena i za elegantan i za sportski stil oblačenja je samo jedan klik od vas. Najbolje tkanine visokog kvaliteta samo u Tudors asortimanu.', 'Džemperi bez rukava,', '', '', '', ''),
(26, 1, 'Manžetne', 'Budite primećeni sa muškom kolekcijom manžetna koja će vam pružiti savršeni šik u muškoj odeći. Najpristupačnije cene manžeta. Ne propustite ovu šansu!', 'Kolekcija manžetni | TUDORS', 'Budite primećeni sa muškom kolekcijom manžetna koja će vam pružiti savršeni šik u muškoj odeći. Najpristupačnije cene manžeta. Ne propustite ovu šansu!', 'Manžetne,', '', '', '', ''),
(27, 1, 'Šnala za kravatu', '', 'Šnala za kravatu', 'Šnala za kravatu', 'Šnala za kravatu,', '', '', '', ''),
(28, 1, 'Parfemi', 'Nabavite najbolje muške parfeme po pristupačnim cenama. Veliki izbor parfema i kolonjskih voda. Brza i sigurna isporuka.', 'Muški parfemi  | TUDORS', 'Nabavite najbolje muške parfeme po pristupačnim cenama. Veliki izbor parfema i kolonjskih voda. Brza i sigurna isporuka.', 'Parfemi,', '', '', '', ''),
(29, 1, 'Igle za kragnu', 'Veliki izbor igli za kragnu sa savršen izgled. Pristupačne cene i brza isporuka. Istražite ponudu i aktuelne akcije!', 'Igle za kragnu | TUDORS', 'Veliki izbor igli za kragnu sa savršen izgled. Pristupačne cene i brza isporuka. Istražite ponudu i aktuelne akcije!', 'Igle za kragnu,', '', '', '', ''),
(30, 1, 'Naočare za sunce', 'Posebna ponuda muških sunčanih naočara stvorena samo za tebe. Neverovatna akcija, poručite još danas.', 'Muške naočare za sunce  | TUDORS', 'Posebna ponuda muških sunčanih naočara stvorena samo za tebe. Neverovatna akcija, poručite još danas.', 'Naočare za sunce,', '', '', '', ''),
(31, 1, 'Kolonjska voda', '', 'Kolonjska voda', 'Kolonjska voda', 'Kolonjska voda,', '', '', '', ''),
(32, 1, 'Ogrlice', 'Za one koji žele da istaknu svoj stil, kolekcija Tudors ogrlica. Dajte pečat svom izgledu uz neku od naših ogrlica.', 'Muške ogrlice  | TUDORS', 'Za one koji žele da istaknu svoj stil, kolekcija Tudors ogrlica. Dajte pečat svom izgledu uz neku od naših ogrlica.', 'Ogrlice,', '', '', '', ''),
(33, 1, 'Prstenje', 'Kolekcija muških prstenova sa pristupačnim cenama i mogućnostima popusta je tu! Poručite sada da biste dobili najpovoljnije muško prstenje.', 'Kolekcija muškog prstenja  | TUDORS', 'Kolekcija muških prstenova sa pristupačnim cenama i mogućnostima popusta je tu! Poručite sada da biste dobili najpovoljnije muško prstenje.', 'Prstenje,', '', '', '', ''),
(34, 1, 'Klasične kravate', '', 'Klasične kravate', 'Klasične kravate', 'Klasične kravate', '', '', '', ''),
(35, 1, 'Uže kravate', '', 'Uže kravate', 'Uže kravate', 'Uže kravate', '', '', '', ''),
(36, 1, 'Slim Fit', '', 'Slim Fit košulje | TUDORS', 'Muške Slim Fit košulje su najbolji izbor sa poseban dan. U ponudi imamo muške košulje sa štampom, Oxford, teksas, karirane, moderne i elegantne košulje pogodne za svakodnevnu upotrebu. Pogledajte kolekciju naših košulja samo na Tudors online.', 'Slim Fit', '', '', '', ''),
(37, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(38, 1, 'Big Size', '', 'Big Size košulje | TUDORS', 'Big size košulje po pristupačnim cenama i brzom isporukom. Istraži kolekicju Big Size košulja i najbolje popuste samo na Tudors online!', 'Big Size', '', '', '', ''),
(39, 1, 'Classic Fit - Comfort Fit', '', 'Classic Fit košulje | TUDORS', 'Nabavite elegantne košulje klasičnog kroja Tudors kvaliteta po pristupačnim cenama. Classic Fit košulje su pravi izbor za svakodnevnu upotrebu. Pogledajte kolekciju naših košulja.', 'Classic Fit - Comfort Fit', '', '', '', ''),
(40, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(41, 1, 'Modern - Slim Fit', '&lt;p&gt;Moderne Slim Fit košulje dugih rukava uskog kroja. Pogodne za svaki dan. Uživajte u kupovini i beslatnoj isporuci!&lt;br&gt;&lt;/p&gt;', 'Modern Fit košulje | TUDORS', 'Modern - Slim Fit', 'Modern - Slim Fit', '', '', '', ''),
(42, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(43, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(44, 1, 'Super Slim Fit', '', 'Super Slim Fit košulje | TUDORS', 'Kolekcija Super Slim muških košulja sa pristupačnim cenama i brzom isporukom samo na Tudors online. Jedistvene boje i šare.', 'Super Slim Fit', '', '', '', ''),
(45, 1, 'Oversize - Relaxed Fit', '', 'Oversize - Relaxed Fit', 'Oversize - Relaxed Fit', 'Oversize - Relaxed Fit', '', '', '', ''),
(46, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(47, 1, 'Oversize - Relaxed Fit', '&lt;p&gt;Oversize muške košulje. Udobna kolekcija muških košulja dugih rukava za svakodnevnu upotrebu. Brza dostava i sigurna kupovina.&lt;br&gt;&lt;/p&gt;', 'Oversize košulje | TUDORS', 'Oversize - Relaxed Fit', 'Oversize - Relaxed Fit', '', '', '', ''),
(48, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(49, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(50, 1, 'Classic Fit - Comfort Fit', '', 'Classic Fit - Comfort Fit', 'Classic Fit - Comfort Fit', 'Classic Fit - Comfort Fit', '', '', '', ''),
(51, 1, 'Slim Fit', '', 'Slim Fit', 'Slim Fit', 'Slim Fit', '', '', '', ''),
(52, 1, 'Big Size', '', 'Big Size', 'Big Size', 'Big Size', '', '', '', ''),
(53, 1, 'Classic Fit - Comfort Fit', '', 'Classic Fit - Comfort Fit', 'Classic Fit - Comfort Fit', 'Classic Fit - Comfort Fit', '', '', '', ''),
(54, 1, 'Classic Fit - Comfort Fit', '', 'Classic Fit - Comfort Fit', 'Classic Fit - Comfort Fit', 'Classic Fit - Comfort Fit', '', '', '', ''),
(55, 1, 'OUTLET', '', 'outlet', '', '', '', '', '', '');
");
		DB::statement("ALTER TABLE `oc_category`
  ADD PRIMARY KEY (`category_id`),
  ADD KEY `parent_id` (`parent_id`);");
		DB::statement("ALTER TABLE `oc_category_description`
  ADD PRIMARY KEY (`category_id`,`language_id`),
  ADD KEY `name` (`name`);");
		DB::statement("ALTER TABLE `oc_category`
  MODIFY `category_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=56;");

		DB::statement("CREATE TABLE `oc_manufacturer` (
  `manufacturer_id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `sort_order` int(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("INSERT INTO `oc_manufacturer` (`manufacturer_id`, `name`, `image`, `sort_order`) VALUES
(1, 'TUDORS', '', 0);");
		DB::statement("CREATE TABLE `oc_manufacturer_to_store` (
  `manufacturer_id` int(11) NOT NULL,
  `store_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("INSERT INTO `oc_manufacturer_to_store` (`manufacturer_id`, `store_id`) VALUES
(1, 0),
(11, 0);");
		DB::statement("ALTER TABLE `oc_manufacturer`
  ADD PRIMARY KEY (`manufacturer_id`);");
		DB::statement("ALTER TABLE `oc_manufacturer_to_store`
  ADD PRIMARY KEY (`manufacturer_id`,`store_id`);");
		DB::statement("ALTER TABLE `oc_manufacturer`
  MODIFY `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;");

		DB::statement("CREATE TABLE `oc_option` (
  `option_id` int(11) NOT NULL,
  `type` varchar(32) NOT NULL,
  `sort_order` int(3) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");

		DB::statement("INSERT INTO `oc_option` (`option_id`, `type`, `sort_order`) VALUES
(2, 'checkbox', 0),
(11, 'radio', 1);");
		DB::statement("CREATE TABLE `oc_option_description` (
  `option_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("INSERT INTO `oc_option_description` (`option_id`, `language_id`, `name`) VALUES
(11, 1, 'Veličina'),
(2, 1, 'Boja');");
		DB::statement("ALTER TABLE `oc_option`
  ADD PRIMARY KEY (`option_id`);");
		DB::statement("ALTER TABLE `oc_option_description`
  ADD PRIMARY KEY (`option_id`,`language_id`);");
		DB::statement("ALTER TABLE `oc_option`
  MODIFY `option_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;");
		DB::statement("CREATE TABLE `oc_option_value` (
  `option_value_id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL,
  `image` varchar(255) NOT NULL,
  `sort_order` int(3) NOT NULL,
  `code` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("INSERT INTO `oc_option_value` (`option_value_id`, `option_id`, `image`, `sort_order`, `code`) VALUES
(1, 2, '0', 0, 'Antrasit'),
(2, 2, '0', 0, 'Bela'),
(3, 2, '0', 0, 'Bež'),
(4, 2, '0', 0, 'Bordo'),
(5, 2, '0', 0, 'Braon'),
(6, 2, '0', 0, 'Cigla'),
(7, 2, '0', 0, 'Ciklama'),
(8, 2, '0', 0, 'Cimet'),
(9, 2, '0', 0, 'Crna'),
(10, 2, '0', 0, 'Crvena'),
(11, 2, '0', 0, 'Dore'),
(12, 2, '0', 0, 'Duvan'),
(13, 2, '0', 0, 'Indigo'),
(14, 2, '0', 0, 'Kaki'),
(15, 2, '0', 0, 'Kamen'),
(16, 2, '0', 0, 'Kombinovana'),
(17, 2, '0', 0, 'Krem'),
(18, 2, '0', 0, 'Lila'),
(19, 2, '0', 0, 'Ljubičasta'),
(20, 2, '0', 0, 'Mint'),
(21, 2, '0', 0, 'Mornarsko plava'),
(22, 2, '0', 0, 'Narandžasta'),
(23, 2, '0', 0, 'Pesak'),
(24, 2, '0', 0, 'Petrol'),
(25, 2, '0', 0, 'Plava'),
(26, 2, '0', 0, 'Puder roze'),
(27, 2, '0', 0, 'Roze'),
(28, 2, '0', 0, 'Sax Plava'),
(29, 2, '0', 0, 'Senf'),
(30, 2, '0', 0, 'Siva'),
(31, 2, '0', 0, 'Srebrna'),
(32, 2, '0', 0, 'Svetlo smeđa'),
(33, 2, '0', 0, 'Tamno siva'),
(34, 2, '0', 0, 'Tirkiz'),
(35, 2, '0', 0, 'Zelena'),
(36, 2, '0', 0, 'Zlatna'),
(37, 2, '0', 0, 'Žuta'),
(38, 11, '', 3, 'L'),
(39, 11, '', 2, 'M'),
(40, 11, '', 4, 'XL'),
(41, 11, '', 1, 'S'),
(42, 11, '', 5, 'XXL'),
(43, 11, '', 6, '2XL'),
(44, 11, '', 7, '3XL'),
(45, 11, '', 8, '4XL'),
(46, 11, '', 0, 'XS'),
(47, 11, '', 0, 'A'),
(48, 11, '', 0, 'I'),
(49, 11, '', 0, 'N'),
(50, 11, '', 9, 'STD');");
		DB::statement("CREATE TABLE `oc_option_value_description` (
  `option_value_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL,
  `name` varchar(128) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		DB::statement("INSERT INTO `oc_option_value_description` (`option_value_id`, `language_id`, `option_id`, `name`) VALUES
(1, 1, 2, 'Antrasit'),
(2, 1, 2, 'Bela'),
(3, 1, 2, 'Bež'),
(4, 1, 2, 'Bordo'),
(5, 1, 2, 'Braon'),
(6, 1, 2, 'Cigla'),
(7, 1, 2, 'Ciklama'),
(8, 1, 2, 'Cimet'),
(9, 1, 2, 'Crna'),
(10, 1, 2, 'Crvena'),
(11, 1, 2, 'Dore'),
(12, 1, 2, 'Duvan'),
(13, 1, 2, 'Indigo'),
(14, 1, 2, 'Kaki'),
(15, 1, 2, 'Kamen'),
(16, 1, 2, 'Kombinovana'),
(17, 1, 2, 'Krem'),
(18, 1, 2, 'Lila'),
(19, 1, 2, 'Ljubičasta'),
(20, 1, 2, 'Mint'),
(21, 1, 2, 'Mornarsko plava'),
(22, 1, 2, 'Narandžasta'),
(23, 1, 2, 'Pesak'),
(24, 1, 2, 'Petrol'),
(25, 1, 2, 'Plava'),
(26, 1, 2, 'Puder roze'),
(27, 1, 2, 'Roze'),
(28, 1, 2, 'Sax Plava'),
(29, 1, 2, 'Senf'),
(30, 1, 2, 'Siva'),
(31, 1, 2, 'Srebrna'),
(32, 1, 2, 'Svetlo smeđa'),
(33, 1, 2, 'Tamno siva'),
(34, 1, 2, 'Tirkiz'),
(35, 1, 2, 'Zelena'),
(36, 1, 2, 'Zlatna'),
(37, 1, 2, 'Žuta'),
(38, 1, 11, 'L'),
(39, 1, 11, 'M'),
(40, 1, 11, 'XL'),
(41, 1, 11, 'S'),
(42, 1, 11, 'XXL'),
(43, 1, 11, '2XL'),
(44, 1, 11, '3XL'),
(45, 1, 11, '4XL'),
(46, 1, 11, 'XS'),
(47, 1, 11, 'A'),
(48, 1, 11, 'I'),
(49, 1, 11, 'N'),
(50, 1, 11, 'STD');");
		DB::statement("ALTER TABLE `oc_option_value`
  ADD PRIMARY KEY (`option_value_id`);");
		DB::statement("ALTER TABLE `oc_option_value_description`
  ADD PRIMARY KEY (`option_value_id`,`language_id`);");
		DB::statement("ALTER TABLE `oc_option_value`
  MODIFY `option_value_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=51;");

		return redirect(route('integrations'));
	}

	public function edit($id) {
		$projectSettings = ProjectSettings::find($id);
		return view('integration-edit', ['projectSettings' => $projectSettings]);
	}

	public function editForm($id, ProjectSettingsEditRequest $request) {
		$projectSettings = ProjectSettings::find($id);
		Logs::createLog($projectSettings->id, "Proje düzenlendi", 0);
		$projectSettings->update($request->toArray());
		return redirect(route('integrations'));
	}

	public function delete($id) {
		$projectSettings = ProjectSettings::find($id);
		Logs::createLog($projectSettings->id, "Proje silindi", 0);
		$projectSettings->delete();
		return redirect(route('integrations'));
	}

	public function stockAndPriceSync($id) {
		Logs::createLog(1, "Updating stock and price.", 0);

		try {
			$nebimService = new NebimDataService();

			// 1.Servisten fiyatları getir.
			$stockList = $nebimService->fetchStockAndPriceFromNebim();

			foreach ($stockList as $stock) {
				$nebimService->updateOpenCartProductOptionValue($stock['Barcode'], $stock['Inventory'], $stock['ItemDim1Code']);
				$nebimService->updatePrice($stock['Barcode'], $stock['Price1'], $stock['Price2']);
			}

			Logs::createLog(1, "Stock and price updated.", 0);

		} catch (\Exception $e) {
			// Hata oluştuğunda bu blok çalışır
			// Loglama yapabilir veya uygun bir hata mesajı döndürebilirsiniz
			Logs::createLog(1, "Stock and price service error: " . $e->getMessage(), 1);
			return; // Hata durumunda işlemi sonlandır
		}
	}

	public function productSync($id) {
		\Artisan::call('nebim:product-sync --projectId=' . $id);
		echo "<script>window.close();</script>";
	}

	public function orderSync($id) {
		\Artisan::call('nebim:order --projectId=' . $id);
		//echo "<script>window.close();</script>";
	}

	public function relatedSync($id) {
		\Artisan::call('nebim:featured ' . $id);

		echo "<script>window.close();</script>";
	}

	public function imageSync($id) {
		\Artisan::call('nebim:images --projectId=' . $id);

		echo "<script>window.close();</script>";
	}

}
