<?php

namespace App\Http\Controllers;

use App\Http\Requests\PasswordUpdateRequest;
use App\Models\Logs;
use App\Models\OpOrder;
use App\Models\OpProduct;
use App\Models\ProjectSettings;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DB;
use Config;

class DashboardController extends Controller
{
    public function dashboard()
    {

        $projectSettings = ProjectSettings::all();

        $projects = [];

        $generalErrors = Logs::where('has_error', 1)->get();
        $errorList = [];
        foreach ($projectSettings as $project) {

            try {
                $databaseConfigName = Str::slug($project->project_name);
                Config::set('database.default', $databaseConfigName);
                $products = OpProduct::select('product_id')->get();
                $orders = OpOrder::select('order_id')->where('order_status_id', $project->order_status_id)->get();
                $ordersWaiting = OpOrder::select('order_id')->where('order_status_id', $project->order_status_id)->where('nebim', '=', 0)->get();
                $errors = Logs::where('has_error', 1)->where('integrationId', $project->id)->get();
                $projects[] = [
                    'projectName' => $project->project_name,
                    'productCount' => $products->count(),
                    'orderCount' => $orders->count(),
                    'ordersWaiting' => $ordersWaiting->count(),
                    'errorCount' => $errors->count(),
                ];

                DB::disconnect('default');
            } catch (\Exception $e) {
                $errorList[] = $project->project_name . " Error :" . $e->getMessage();
            }
        }

        return view('dashboard', ['integrationCount' => $projectSettings->count(), 'errorCount' => $generalErrors->count(), 'projects' => $projects, 'errorList' => $errorList]);
    }

    public function login(Request $request)
    {
        /*$user = new User();
        $user->password = Hash::make('tudors-1234');
        $user->email = 'integrator@tudors.com';
        $user->name = 'Tudors';
        $user->save();
        */

        $request->email = 'integrator@tudors.com';

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            return redirect()->intended('dashboard');
        }


        return view('login');

    }

    public function passwordUpdate(PasswordUpdateRequest $request)
    {

        $userId = Auth::id();
        User::where('id', $userId)->update([
            'password' => Hash::make($request->password)
        ]);

        return view('password-update');
    }
}
