<?php

namespace App\Console\Commands;

use App\Models\OpProduct;
use App\Models\OpProductImage;
use App\Models\ProjectSettings;
use Config;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Str;
use App\Models\Logs;
use Cron\CronExpression;

class OpenCartCheckStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'op:checkstatus {--projectId=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
   
    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {


        $projectId = $this->option('projectId');
        $projects = ProjectSettings::all();
        $date = Date::now();

        foreach ($projects as $project) {

            if ($projectId) {
                if ($projectId != $project->id) {
                    continue;
                }
            } else {
                $checkExpression = (new CronExpression($project->opencart_check))->isDue($date->toDateTimeString());
                if (!$checkExpression) {
                    continue;
                }
            }

            Logs::createLog($project->id, "Data maintenance of Product check started.", 0);
            config()->set('database.connections.' . Str::slug($project->project_name), [
                'driver' => 'mysql',
                'url' => null,
                'host' => $project->database_host,
                'port' => $project->database_port,
                'database' => $project->database_name,
                'username' => $project->database_username,
                'password' => $project->database_password,
                'unix_socket' => null,
                'charset' => 'utf8mb4',
                'collation' => 'utf8mb4_unicode_ci',
                'prefix' => null,
                'prefix_indexes' => 1,
                'strict' => 1,
                'engine' => null,
                'options' => [],
            ]);

            $databaseConfigName = Str::slug($project->project_name);
            Config::set('database.default', $databaseConfigName);




            $opProducts = OpProduct::all();
            foreach ($opProducts as $opProduct) {

                if ($opProduct->price > 0 and $opProduct->quantity > 0 and $opProduct->image != "") {
                    OpProduct::where('product_id', $opProduct->product_id)->update([
                        'status' => 1,
                    ]);
                } else {
                    OpProduct::where('product_id', $opProduct->product_id)->update([
                        'status' => 0,
                    ]);
                }
            }
            Logs::createLog($project->id, "Data maintenance of Product check finished.", 0);

        }

        return 0;
    }
}
