<?php

namespace App\Console\Commands;

use App\Models\OpProduct;
use App\Models\OpProductImage;
use App\Models\ProjectSettings;
use Config;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Str;

class OpImagesFixCommmand extends Command {
	/**
	 * The name and signature of the console command.
	 *
	 * @var string
	 */
	protected $signature = 'op:images-fix';

	/**
	 * The console command description.
	 *
	 * @var string
	 */
	protected $description = 'Command description';

	/**
	 * Create a new command instance.
	 *
	 * @return void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Execute the console command.
	 *
	 * @return int
	 */
	public function handle() {
		$projects = ProjectSettings::all();
		$date = Date::now();
		Logs::createLog($project->id, "Resim Kontrolü Başlatıldı.", 0);

		foreach ($projects as $project) {
			$databaseConfigName = Str::slug($project->project_name);
			Config::set('database.default', $databaseConfigName);

			$checkImages = OpProductImage::where('image', '')->get();
			foreach ($checkImages as $checkImage) {
				$opProduct = OpProduct::where('product_id', $checkImage->product_id)->first();
				$model = $opProduct->model;
				$imageUrl = "https://img.tudors.com/" . $model . "-" . $checkImage->sort_order . ".jpg";

				OpProductImage::where('product_image_id', $checkImage->product_image_id)->update([
					'image' => $imageUrl,
				]);

			}
		}
		return 0;
	}
}
