<?php

namespace App\Console\Commands;

use App\Models\Logs;
use App\Models\OpProduct;
use App\Models\OpProductImage;
use App\Models\ProjectSettings;
use Config;
use Cron\CronExpression;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;

class NebimImagesSync extends Command {
	/**
	 * The name and signature of the console command.
	 *
	 * @var string
	 */
	protected $signature = 'nebim:images {--projectId=}';

	/**
	 * The console command description.
	 *
	 * @var string
	 */
	protected $description = 'Siparişleri Nebime aktarır.';

	/**
	 * Create a new command instance.
	 *
	 * @return void
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Execute the console command.
	 *
	 * @return int
	 */
	public function handle() {
		$projectId = $this->option('projectId');
		$projects = ProjectSettings::all();

		foreach ($projects as $project) {
			if ($projectId) {
				if ($projectId != $project->id) {
					continue;
				}
			} else {
				$checkExpression = (new CronExpression($project->images_schedule))->isDue(Date::now()->toDateTimeString());
				if (!$checkExpression) {
					continue;
				}
			}

			Logs::createLog($project->id, "Nebim - Transfer of images started.", 0);

			$databaseConfigName = Str::slug($project->project_name);
			Config::set('database.default', $databaseConfigName);

			//OpProductImage::query()->delete();
			try {
				$opProducts = OpProduct::where('image', '')->get();
				foreach ($opProducts as $opProduct) {

					$model = $opProduct->model;
					for ($i = 1; $i <= 6; $i++) {
						$imageUrl = "https://img.tudors.com/" . $model . "-" . $i . ".jpg";
						$response = Http::get($imageUrl);
						if ($response->status() === 404) {
							continue;
						}
						if ($i == 1) {
							OpProduct::where('product_id', $opProduct->product_id)->update(['image' => $imageUrl]);
						} else {
							$checkImage = OpProductImage::where('product_id', $opProduct->product_id)->where('image', $imageUrl)->first();
							if (!$checkImage) {
								$opProductImage = new OpProductImage();
								$opProductImage->product_id = $opProduct->product_id;
								$opProductImage->image = $imageUrl;
								$opProductImage->sort_order = $i;
								$opProductImage->save();
							}

						}
					}
				}
				Logs::createLog($project->id, "Nebim -Transfer of images finished.", 0);

			} catch (\Exception $e) {
				Logs::createLog($project->id, $e->getMessage(), 1);
			}
		}

		return 0;
	}
}
