<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\OpProduct;
use App\Models\OpProductImage;
use App\Models\ProjectSettings;
use Config;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Str;
use App\Models\Logs;
use Cron\CronExpression;

class OpenCartCheckImage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'op:checkimage';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
  
    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $projects = ProjectSettings::all();
        $date     = Date::now();



        foreach ($projects as $project) {

          
				$checkExpression = (new CronExpression($project->opencart_checkimage))->isDue($date->toDateTimeString());
				if (!$checkExpression) {
					continue;
				}
			


            config()->set('database.connections.' . Str::slug($project->project_name), [
                'driver' => 'mysql',
                'url' => null,
                'host' => $project->database_host,
                'port' => $project->database_port,
                'database' => $project->database_name,
                'username' => $project->database_username,
                'password' => $project->database_password,
                'unix_socket' => null,
                'charset' => 'utf8mb4',
                'collation' => 'utf8mb4_unicode_ci',
                'prefix' => null,
                'prefix_indexes' => 1,
                'strict' => 1,
                'engine' => null,
                'options' => [],
            ]);

            $databaseConfigName = Str::slug($project->project_name);
            Config::set('database.default', $databaseConfigName);


            Logs::createLog($project->id, "Data maintenance of product images", 0);





            $images = OpProductImage::where('image', '')->get();

            if ($images->count() > 0) {
                Logs::createLog($project->id, $images->count() . " Image Broken.Fixed.", 0);

            }
            foreach ($images as $img) {
                $opProducts = OpProduct::where('product_id', $img->product_id)->update(['image' => ""]);


                $deleteimg = OpProductImage::where('product_image_id', $img->product_image_id)->delete();
            }

            Logs::createLog($project->id, "Cleaning maintenance of duplicate Products ", 0);

            $dublicate = OpProduct::select('model')->groupby('model')->havingRaw('COUNT(*) > 1')->get();

            if ($dublicate->count() > 0) {
                Logs::createLog($project->id, "True - DuplicateMaintenance-Products", 0);

            }
            Logs::createLog($project->id, "Data maintenance of product images-  finished.", 0);


        }

        return 0;
    }
}