<?php

namespace App\Console\Commands;

use App\Models\IntegrationProducts;
use App\Models\IntegrationProductStocks;
use App\Models\Logs;
use App\Models\OpOrder;
use App\Models\OpOrderOption;
use App\Models\OpOrderProduct;
use App\Models\OpProduct;
use App\Models\OpProductOptionValue;
use App\Models\OpProductSpecial;
use App\Models\ProjectSettings;
use App\Providers\NebimProvider;
use Config;
use Cron\CronExpression;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class NebimStockTest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nebim:stock-test';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    function replace_tr($text)
    {
        $text     = trim($text);
        $search   = array('Ç', 'ç', 'Ğ', 'ğ', 'ı', 'İ', 'Ö', 'ö', 'Ş', 'ş', 'Ü', 'ü', 'd', ' ');
        $replace  = array('C', 'C', 'G', 'G', 'I', 'I', 'O', 'O', 'S', 'S', 'U', 'U', 'D', '-');
        $new_text = str_replace($search, $replace, $text);
        return $new_text;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $projects = ProjectSettings::all();

        foreach ($projects as $project) {


            try {

                Logs::createLog($project->id, "Stock and price transfer has started", 0);


                config()->set('database.connections.' . Str::slug($project->project_name), [
                    'driver' => 'mysql',
                    'url' => null,
                    'host' => $project->database_host,
                    'port' => $project->database_port,
                    'database' => $project->database_name,
                    'username' => $project->database_username,
                    'password' => $project->database_password,
                    'unix_socket' => null,
                    'charset' => 'utf8mb4',
                    'collation' => 'utf8mb4_unicode_ci',
                    'prefix' => null,
                    'prefix_indexes' => 1,
                    'strict' => 1,
                    'engine' => null,
                    'options' => [],
                ]);

                $databaseConfigName = Str::slug($project->project_name);

                Config::set('database.default', $databaseConfigName);

                $nebimProvider = new NebimProvider($project->nebim_url, $project->nebim_database_name, $project->nebim_user_group_code, $project->nebim_username, $project->nebim_password);

                $productPrices = $nebimProvider->getProducts($project->ProductDetail);
                Storage::put('products_' . $project->id . '.json', $productPrices);

                $nebimProducts = Storage::get('products_' . $project->id . '.json');
                $nebimProducts = json_decode($nebimProducts, true);

                Logs::createLog($project->id, "Pulling data from my Nebim", 0);

                IntegrationProducts::where('integrationId', $project->id)->delete();
                foreach ($nebimProducts as $nebimProduct) {
                    if(isset($nebimProduct['ProductCode']))
                    {


                    $productCode = $this->replace_tr($nebimProduct['ProductCode']);

                    if (strlen($nebimProduct['ColorCode']) == 0) {
                        $stockCode = $this->replace_tr($nebimProduct['ProductCode']);
                    } else {
                        $colorCode = $this->replace_tr($nebimProduct['ColorCode']);
                        $stockCode = $productCode . "-" . $colorCode;
                    }

                    $checkIntegrationProduct = IntegrationProducts::where('StockCode', $stockCode)->first();
                    if ($checkIntegrationProduct) {
                        continue;
                    }

                    $integrationProduct                              = new IntegrationProducts();
                    $integrationProduct->integrationId               = $project->id;
                    $integrationProduct->WarehouseCode               = $nebimProduct['WarehouseCode'] ?? "";
                    $integrationProduct->WarehouseDescription        = $nebimProduct['WarehouseDescription'] ?? "";
                    $integrationProduct->ProductCode                 = $productCode;
                    $integrationProduct->ProductDescription          = $stockCode;
                    $integrationProduct->VatRate                     = $stockCode;
                    $integrationProduct->ColorCode                   = $colorCode;
                    $integrationProduct->ColorDescription            = $nebimProduct['ColorDescription'] ?? "";
                    $integrationProduct->ColorGroupDescription       = $nebimProduct['ColorGroupDescription'] ?? "";
                    $integrationProduct->ColorGroupCode              = $nebimProduct['ColorGroupCode'] ?? "";
                    $integrationProduct->ItemDim1Code                = $nebimProduct['ItemDim1Code'] ?? "";
                    $integrationProduct->Barcode                     = $nebimProduct['Barcode'] ?? "";
                    $integrationProduct->Warehouse1InventoryQty      = $nebimProduct['Warehouse1InventoryQty'] ?? "";
                    $integrationProduct->Price1CurrencyCode          = $nebimProduct['Price1CurrencyCode'] ?? "";
                    $integrationProduct->Price1                      = $nebimProduct['Price1'] ?? "";
                    $integrationProduct->ProductHierarchyLevel01     = $nebimProduct['ProductHierarchyLevel01'] ?? "";
                    $integrationProduct->ProductHierarchyLevelCode01 = $nebimProduct['ProductHierarchyLevelCode01'] ?? "";
                    $integrationProduct->ProductHierarchyLevel02     = $nebimProduct['ProductHierarchyLevel02'] ?? "";
                    $integrationProduct->ProductHierarchyLevelCode02 = $nebimProduct['ProductHierarchyLevelCode02'] ?? "";
                    $integrationProduct->ProductHierarchyLevel03     = $nebimProduct['ProductHierarchyLevel03'] ?? "";
                    $integrationProduct->ProductHierarchyLevelCode03 = $nebimProduct['ProductHierarchyLevelCode03'] ?? "";
                    $integrationProduct->ProductAtt01                = $nebimProduct['ProductAtt01'] ?? "";
                    $integrationProduct->ProductAtt02                = $nebimProduct['ProductAtt02'] ?? "";
                    $integrationProduct->ProductAtt03                = $nebimProduct['ProductAtt03'] ?? "";
                    $integrationProduct->ProductAtt04                = $nebimProduct['ProductAtt04'] ?? "";
                    $integrationProduct->ProductAtt05                = $nebimProduct['ProductAtt05'] ?? "";
                    $integrationProduct->ProductAtt06                = $nebimProduct['ProductAtt06'] ?? "";
                    $integrationProduct->ProductAtt07                = $nebimProduct['ProductAtt07'] ?? "";
                    $integrationProduct->ProductAtt08                = $nebimProduct['ProductAtt08'] ?? "";
                    $integrationProduct->ProductAtt09                = $nebimProduct['ProductAtt09'] ?? "";
                    $integrationProduct->ProductAtt10                = $nebimProduct['ProductAtt10'] ?? "";
                    $integrationProduct->ProductAtt11                = $nebimProduct['ProductAtt11'] ?? "";
                    $integrationProduct->ProductAtt12                = $nebimProduct['ProductAtt12'] ?? "";
                    $integrationProduct->ProductAtt13                = $nebimProduct['ProductAtt13'] ?? "";
                    $integrationProduct->ProductAtt14                = $nebimProduct['ProductAtt14'] ?? "";
                    $integrationProduct->ProductAtt15                = $nebimProduct['ProductAtt15'] ?? "";
                    $integrationProduct->ProductAtt16                = $nebimProduct['ProductAtt16'] ?? "";
                    $integrationProduct->ProductAtt17                = $nebimProduct['ProductAtt17'] ?? "";
                    $integrationProduct->ProductAtt18                = $nebimProduct['ProductAtt18'] ?? "";
                    $integrationProduct->ProductAtt19                = $nebimProduct['ProductAtt19'] ?? "";
                    $integrationProduct->ProductAtt20                = $nebimProduct['ProductAtt20'] ?? "";
                    $integrationProduct->ProductAtt21                = $nebimProduct['ProductAtt21'] ?? "";
                    $integrationProduct->ProductAtt22                = $nebimProduct['ProductAtt22'] ?? "";
                    $integrationProduct->ProductAtt23                = $nebimProduct['ProductAtt23'] ?? "";
                    $integrationProduct->ProductAtt24                = $nebimProduct['ProductAtt24'] ?? "";
                    $integrationProduct->ProductAtt25                = $nebimProduct['ProductAtt25'] ?? "";
                    $integrationProduct->ProductAtt26                = $nebimProduct['ProductAtt26'] ?? "";
                    $integrationProduct->ProductAtt27                = $nebimProduct['ProductAtt27'] ?? "";
                    $integrationProduct->ProductAtt01Desc            = $nebimProduct['ProductAtt01Desc'] ?? "";
                    $integrationProduct->ProductAtt02Desc            = $nebimProduct['ProductAtt02Desc'] ?? "";
                    $integrationProduct->ProductAtt03Desc            = $nebimProduct['ProductAtt03Desc'] ?? "";
                    $integrationProduct->ProductAtt04Desc            = $nebimProduct['ProductAtt04Desc'] ?? "";
                    $integrationProduct->ProductAtt05Desc            = $nebimProduct['ProductAtt05Desc'] ?? "";
                    $integrationProduct->ProductAtt06Desc            = $nebimProduct['ProductAtt06Desc'] ?? "";
                    $integrationProduct->ProductAtt07Desc            = $nebimProduct['ProductAtt07Desc'] ?? "";
                    $integrationProduct->ProductAtt08Desc            = $nebimProduct['ProductAtt08Desc'] ?? "";
                    $integrationProduct->ProductAtt09Desc            = $nebimProduct['ProductAtt09Desc'] ?? "";
                    $integrationProduct->ProductAtt10Desc            = $nebimProduct['ProductAtt10Desc'] ?? "";
                    $integrationProduct->ProductAtt11Desc            = $nebimProduct['ProductAtt11Desc'] ?? "";
                    $integrationProduct->ProductAtt12Desc            = $nebimProduct['ProductAtt12Desc'] ?? "";
                    $integrationProduct->ProductAtt13Desc            = $nebimProduct['ProductAtt13Desc'] ?? "";
                    $integrationProduct->ProductAtt14Desc            = $nebimProduct['ProductAtt14Desc'] ?? "";
                    $integrationProduct->ProductAtt15Desc            = $nebimProduct['ProductAtt15Desc'] ?? "";
                    $integrationProduct->ProductAtt16Desc            = $nebimProduct['ProductAtt16Desc'] ?? "";
                    $integrationProduct->ProductAtt17Desc            = $nebimProduct['ProductAtt17Desc'] ?? "";
                    $integrationProduct->ProductAtt18Desc            = $nebimProduct['ProductAtt18Desc'] ?? "";
                    $integrationProduct->ProductAtt19Desc            = $nebimProduct['ProductAtt19Desc'] ?? "";
                    $integrationProduct->ProductAtt20Desc            = $nebimProduct['ProductAtt20Desc'] ?? "";
                    $integrationProduct->ProductAtt21Desc            = $nebimProduct['ProductAtt21Desc'] ?? "";
                    $integrationProduct->ProductAtt22Desc            = $nebimProduct['ProductAtt22Desc'] ?? "";
                    $integrationProduct->ProductAtt23Desc            = $nebimProduct['ProductAtt23Desc'] ?? "";
                    $integrationProduct->ProductAtt24Desc            = $nebimProduct['ProductAtt24Desc'] ?? "";
                    $integrationProduct->ProductAtt25Desc            = $nebimProduct['ProductAtt25Desc'] ?? "";
                    $integrationProduct->ProductAtt26Desc            = $nebimProduct['ProductAtt26Desc'] ?? "";
                    $integrationProduct->ProductAtt27Desc            = $nebimProduct['ProductAtt27Desc'] ?? "";
                    $integrationProduct->ProductAtt28Desc            = $nebimProduct['ProductAtt28Desc'] ?? "";
                    $integrationProduct->Price2                      = $nebimProduct['Price2'] ?? "";
                    $integrationProduct->StockCode                   = $stockCode;
                    $integrationProduct->save();
                }
                else
                {
                    Logs::createLog($project->id, "Product Barcode not correct." . 0);

                }
                }

                unset($nebimProducts);
                Logs::createLog($project->id, "Stock transfer finished. Price continue.", 0);

                //Logs::createLog($project->id, "Nebim Ürün Stok Aktarımı Başladı", 0);

                IntegrationProductStocks::where('integrationId', $project->id)->delete();
                $products = $nebimProvider->getStockAndPrices($project->ProductInventory);
                Storage::put('stocks_' . $project->id . '.json', json_encode($products, true));
                $nebimStocks = Storage::get('stocks_' . $project->id . '.json');
                $nebimStocks = json_decode($nebimStocks, true);

                foreach ($nebimStocks as $nebimStock) {
                    if (isset($nebimStock['Barcode'])) {



                        $stockFix = IntegrationProductStocks::where('Barcode', $nebimStock['Barcode'])->where('integrationId', $project->id)->first();
                        if ($stockFix) {
                            continue;
                        }

                        $productCode = $this->replace_tr($nebimStock['ProductCode']);

						if (strlen($nebimStock['ColorCode']) == 0) {
							$stockCode = $this->replace_tr($nebimStock['ProductCode']);
						} else {
							$colorCode = $this->replace_tr($nebimStock['ColorCode']);
							$stockCode = $productCode . "-" . $colorCode;
						}

                        $integrationProductStock                         = new IntegrationProductStocks();
                        $integrationProductStock->integrationId          = $project->id;
                        $integrationProductStock->ProductCode            = $stockCode;
                        $integrationProductStock->Barcode                = $nebimStock['Barcode'];
                        $integrationProductStock->Warehouse1InventoryQty = $nebimStock['Warehouse1InventoryQty'];
                        $integrationProductStock->ItemDim1Code           = $nebimStock['ItemDim1Code'];
                        $integrationProductStock->save();
                    } else {
                        Logs::createLog($project->id, "Barcode not correct." . 0);

                    }
                }
                Logs::createLog($project->id, "Integration Product created. ", 0);

                $integrationProductStocks = IntegrationProductStocks::where('integrationId', $project->id)->get();
                foreach ($integrationProductStocks as $integrationProductStock) {
                    if (strlen($integrationProductStock->ItemDim1Code) > 0) {
                        $opProductOptionValue = OpProductOptionValue::where('ean', $integrationProductStock->Barcode)->first();
                        if ($opProductOptionValue) {
                            $calcStockTotal = IntegrationProductStocks::selectRaw('SUM(Warehouse1InventoryQty) AS totalStock')->where('Barcode', $integrationProductStock->Barcode)->where('integrationId', $project->id)->first();

                            if ($calcStockTotal->totalStock > 0) {
                                OpProductOptionValue::where('product_option_value_id', $opProductOptionValue->product_option_value_id)->update([
                                    'quantity' => $calcStockTotal->totalStock,
                                ]);

                            }
                        }
                    }
                }
                Logs::createLog($project->id, "Transferring stock data to opencart", 0);

                $opProductOptions = OpProductOptionValue::where('quantity', '>', 0)->get();
                foreach ($opProductOptions as $opProductOption) {
                    $opProductOptionValue = IntegrationProductStocks::where('Barcode', $opProductOption->ean)->where('integrationId', $project->id)->first();
                    if (!$opProductOptionValue) {
                        OpProductOptionValue::where('product_option_value_id', $opProductOption->product_option_value_id)->update([
                            'quantity' => 0,
                        ]);
                    }
                }

                $opProducts = OpProduct::all();
                foreach ($opProducts as $opProduct) {
                    $integrationProductStock = IntegrationProductStocks::where('Barcode', $opProduct->ean)->where('integrationId', $project->id)->first();
                    if ($integrationProductStock) {
                        $calcStockTotal = IntegrationProductStocks::where('Barcode', $opProduct->ean)->where('integrationId', $project->id)->first();
                        $stock          = $calcStockTotal->Warehouse1InventoryQty;
                        if ($stock <= "0") {
                            $status = "0";
                            $stock  = "0";
                        } else {
                            $status = "1";
                        }
                        OpProduct::where('product_id', $opProduct->product_id)->update([
                            'quantity' => $stock,
                            'status' => $status,
                        ]);

                        if ($opProduct->image != "") {
                            OpProduct::where('product_id', $opProduct->product_id)->update([
                                'status' => "1",
                            ]);
                        } else {
                            OpProduct::where('product_id', $opProduct->product_id)->update([
                                'status' => "0",
                            ]);
                        }
                    } else {
                        OpProduct::where('product_id', $opProduct->product_id)->update([
                            'quantity' => "0",
                            'status' => "0",
                        ]);
                    }
                }
                $opProducts = OpProduct::all();
                foreach ($opProducts as $opProduct) {
                    if ($opProduct->model != "") {
                        $integrationProduct = IntegrationProducts::where('StockCode', $opProduct->model)->first();
                        if ($integrationProduct) {
                            if ($integrationProduct->Price2 == "0") {
                                OpProduct::where('model', $opProduct->model)->update([
                                    'price' => $integrationProduct->Price1,
                                ]);
                            } else {
                                OpProduct::where('model', $opProduct->model)->update([
                                    'price' => $integrationProduct->Price2,
                                ]);
                            }
                        }
                    }
                }

                $opProductSpecials = OpProductSpecial::all();
                foreach ($opProductSpecials as $opProductSpecial) {
                    $opProduct = OpProduct::where('product_id', $opProductSpecial->product_id)->first();
                    if ($opProduct) {
                        if ($opProductSpecial->price == $opProduct->price) {
                            OpProductSpecial::where('product_special_id', $opProductSpecial->product_special_id)->delete();
                        }
                    }
                }

                $integrationProducts = IntegrationProducts::all();
                foreach ($integrationProducts as $integrationProduct) {
                    $opProduct = OpProduct::where('model', $integrationProduct->StockCode)->first();
                    if ($opProduct) {

                        $opProductSpecial = OpProductSpecial::where('product_id', $opProduct->product_id)->first();
                        if (!$opProductSpecial) {
                            if ($integrationProduct->Price2 != "0") {
                                $newOpProductSpecial                    = new OpProductSpecial();
                                $newOpProductSpecial->product_id        = $opProduct->product_id;
                                $newOpProductSpecial->customer_group_id = "1";
                                $newOpProductSpecial->priority          = "0";
                                $newOpProductSpecial->price             = "$integrationProduct->Price1";
                                $newOpProductSpecial->date_start        = "1970-01-01";
                                $newOpProductSpecial->date_end          = "2025-01-01";
                                $newOpProductSpecial->save();
                            }
                        } else {
                            if ($integrationProduct->Price2 != "0") {
                                OpProductSpecial::where('product_special_id', $opProductSpecial)->update([
                                    'price' => $integrationProduct->Price1,
                                ]);
                            }
                        }
                    }

                }

                $opProductSpecials = OpProductSpecial::all();
                foreach ($opProductSpecials as $opProductSpecial) {

                    $opProduct = OpProduct::where('product_id', $opProductSpecial->product_id)->first();

                    if ($opProduct) {

                        $integrationProduct = IntegrationProducts::where('StockCode', $opProduct->model)->first();
                        if ($integrationProduct) {
                            if ($integrationProduct->Price2 == "0") {
                                OpProductSpecial::where('product_special_id', $opProductSpecial->product_special_id)->delete();
                            }

                            if ($opProductSpecial->price > $opProduct->price) {
                                OpProductSpecial::where('product_special_id', $opProductSpecial->product_special_id)->delete();
                            }

                        }

                    }
                }

                $opOrders = OpOrder::where('order_status_id', '!=', 0)->where('nebim', 0)->get();

                foreach ($opOrders as $opOrder) {

                    $opOrderProducts = OpOrderProduct::where('order_id', $opOrder->order_id)->get();

                    foreach ($opOrderProducts as $opOrderProduct) {

                        $isVariant = OpOrderOption::where('order_id', $opOrderProduct->order_id)->where('order_product_id', $opOrderProduct->order_product_id)->first();
                        if ($isVariant) {

                            $opProductOptionValue = OpProductOptionValue::where('product_option_id', $isVariant->product_option_id)->where('product_option_value_id', $isVariant->product_option_value_id)->first();
                            if ($opProductOptionValue->quantity - $opOrderProduct->quantity < 0) {
                                $quantity = 0;
                            } else {
                                $quantity = $opProductOptionValue->quantity - $opOrderProduct->quantity;
                            }

                            OpProductOptionValue::where('product_option_id', $isVariant->product_option_id)->where('product_option_value_id', $isVariant->product_option_value_id)->update([
                                'quantity' => $quantity,
                            ]);

                        } else {
                            $opProduct = OpProduct::where('product_id', $opOrderProduct->product_id)->first();
                            if ($opProduct->quantity - $opOrderProduct->quantity < 0) {
                                $quantity = 0;
                            } else {
                                $quantity = $opProduct->quantity - $opOrderProduct->quantity;
                            }

                            OpProduct::where('product_id', $opOrderProduct->product_id)->update([
                                'quantity' => $quantity,
                            ]);
                        }

                    }

                }

                Logs::createLog($project->id, "Transferring price data to opencart", 0);

                $products = OpProduct::with('integration', 'special')->get();

                $data = array();

                foreach ($products as $product) {

                    if ($product->price > 0) {
                        if ($product->special->first() == TRUE) {

                            if ($product->special->first()->price > 0) {

                                $findspecial = OpProductSpecial::where('product_id', $product->product_id)->first();

                                if ($product->integration == TRUE) {

                                    if ($product->integration->Price1 > 0) {
                                        $findagan = OpProductSpecial::where('product_special_id', $findspecial->product_special_id)->update(array('price' => $product->integration->Price1));

                                    }
                                    if ($product->integration->Price2 == 0) {
                                        $findagan      = OpProductSpecial::where('product_special_id', $findspecial->product_special_id)->delete();
                                        $updateproduct = OpProduct::where('model', $product->model)->update([
                                            'price' => $product->integration->Price1,
                                        ]);

                                    }

                                } else {
                                    //  $findagan = OpProductSpecial::where('product_special_id', $findspecial->product_special_id)->delete();

                                }

                            }

                        }
                    }

                }



                Logs::createLog($project->id, "Stock and price transfer has finished.", 0);
            } catch (\Exception $e) {
                echo $e;
                Logs::createLog($project->id, $e->getMessage(), 1);
            }

        }

        return 0;
    }
}