<?php

namespace App\Console\Commands;

use App\Models\IntegrationProducts;
use App\Models\Logs;
use App\Models\OpCategory;
use App\Models\OpOptionValue;
use App\Models\OpProduct;
use App\Models\OpProductAttribute;
use App\Models\OpProductDescription;
use App\Models\OpProductOption;
use App\Models\OpProductOptionValue;
use App\Models\OpProductToCategory;
use App\Models\OpProductToLayout;
use App\Models\OpProductToStore;
use App\Models\ProjectSettings;
use App\Providers\NebimProvider;
use Config;
use Cron\CronExpression;
use DB;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class NebimProductsSync extends Command {
	/**
	 * The name and signature of the console command.
	 *
	 * @var string
	 */
	protected $signature = 'nebim:product-sync {--projectId=}';

	/**
	 * The console command description.
	 *
	 * @var string
	 */
	protected $description = 'Command description';

	/**
	 * Create a new command instance.
	 *
	 * @return void
	 */
	public function __construct() {
		parent::__construct();
	}

	function replace_tr($text) {
		$text = trim($text);
		$search = array('Ç', 'ç', 'Ğ', 'ğ', 'ı', 'İ', 'Ö', 'ö', 'Ş', 'ş', 'Ü', 'ü', 'd', ' ');
		$replace = array('C', 'C', 'G', 'G', 'I', 'I', 'O', 'O', 'S', 'S', 'U', 'U', 'D', '-');
		$new_text = str_replace($search, $replace, $text);
		return $new_text;
	}

	/**
	 * Execute the console command.
	 *
	 * @return int
	 */
	public function handle() {
		$projectId = $this->option('projectId');
		$projects = ProjectSettings::all();
		$date = Date::now();

		foreach ($projects as $project) {

			if ($projectId) {
				if ($projectId != $project->id) {
					continue;
				}
			} else {
				$checkExpression = (new CronExpression($project->product_schedule))->isDue($date->toDateTimeString());
				if (!$checkExpression) {
					continue;
				}
			}

			Logs::createLog($project->id, "Product transfer started", 0);
			$databaseConfigName = Str::slug($project->project_name);
			Config::set('database.default', $databaseConfigName);

			try {

				$fresh = false;
				if ($fresh) {
					OpProductOptionValue::query()->delete();
					OpProductToCategory::query()->delete();
					OpProductOption::query()->delete();
					OpProductToStore::query()->delete();
					OpProductToLayout::query()->delete();
					OpProductDescription::query()->delete();
					OpProduct::query()->delete();
					OpProductAttribute::query()->delete();
					exit();
				}

				$nebimProvider = new NebimProvider($project->nebim_url, $project->nebim_database_name, $project->nebim_user_group_code, $project->nebim_username, $project->nebim_password);

				$products = $nebimProvider->getProducts($project->ProductDetail);
				Storage::put('products_' . $project->id . '.json', $products);

				$nebimProducts = Storage::get('products_' . $project->id . '.json');
				$nebimProducts = json_decode($nebimProducts, true);

				IntegrationProducts::where('integrationId', $project->id)->delete();

				foreach ($nebimProducts as $nebimProduct) {
					$productCode = $this->replace_tr($nebimProduct['ProductCode']);

					if (strlen($nebimProduct['ColorCode']) == 0) {
						$stockCode = $this->replace_tr($nebimProduct['ProductCode']);
					} else {
						$colorCode = $this->replace_tr($nebimProduct['ColorCode']);
						$stockCode = $productCode . "-" . $colorCode;
					}

					$integrationProduct = new IntegrationProducts();
					$integrationProduct->integrationId = $project->id;
					$integrationProduct->WarehouseCode = $nebimProduct['WarehouseCode'] ?? "";
					$integrationProduct->WarehouseDescription = $nebimProduct['WarehouseDescription'] ?? "";
					$integrationProduct->ProductCode = $productCode;
					$integrationProduct->ProductDescription = $stockCode;
					$integrationProduct->VatRate = $stockCode;
					$integrationProduct->ColorCode = $colorCode;
					$integrationProduct->ColorDescription = $nebimProduct['ColorDescription'] ?? "";
					$integrationProduct->ColorGroupDescription = $nebimProduct['ColorGroupDescription'] ?? "";
					$integrationProduct->ColorGroupCode = $nebimProduct['ColorGroupCode'] ?? "";
					$integrationProduct->ItemDim1Code = $nebimProduct['ItemDim1Code'] ?? "";
					$integrationProduct->Barcode = $nebimProduct['Barcode'] ?? "";
					$integrationProduct->Warehouse1InventoryQty = $nebimProduct['Warehouse1InventoryQty'] ?? "";
					$integrationProduct->Price1CurrencyCode = $nebimProduct['Price1CurrencyCode'] ?? "";
					$integrationProduct->Price1 = $nebimProduct['Price1'] ?? "";
					$integrationProduct->ProductHierarchyLevel01 = $nebimProduct['ProductHierarchyLevel01'] ?? "";
					$integrationProduct->ProductHierarchyLevelCode01 = $nebimProduct['ProductHierarchyLevelCode01'] ?? "";
					$integrationProduct->ProductHierarchyLevel02 = $nebimProduct['ProductHierarchyLevel02'] ?? "";
					$integrationProduct->ProductHierarchyLevelCode02 = $nebimProduct['ProductHierarchyLevelCode02'] ?? "";
					$integrationProduct->ProductHierarchyLevel03 = $nebimProduct['ProductHierarchyLevel03'] ?? "";
					$integrationProduct->ProductHierarchyLevelCode03 = $nebimProduct['ProductHierarchyLevelCode03'] ?? "";
					$integrationProduct->ProductAtt01 = $nebimProduct['ProductAtt01'] ?? "";
					$integrationProduct->ProductAtt02 = $nebimProduct['ProductAtt02'] ?? "";
					$integrationProduct->ProductAtt03 = $nebimProduct['ProductAtt03'] ?? "";
					$integrationProduct->ProductAtt04 = $nebimProduct['ProductAtt04'] ?? "";
					$integrationProduct->ProductAtt05 = $nebimProduct['ProductAtt05'] ?? "";
					$integrationProduct->ProductAtt06 = $nebimProduct['ProductAtt06'] ?? "";
					$integrationProduct->ProductAtt07 = $nebimProduct['ProductAtt07'] ?? "";
					$integrationProduct->ProductAtt08 = $nebimProduct['ProductAtt08'] ?? "";
					$integrationProduct->ProductAtt09 = $nebimProduct['ProductAtt09'] ?? "";
					$integrationProduct->ProductAtt10 = $nebimProduct['ProductAtt10'] ?? "";
					$integrationProduct->ProductAtt11 = $nebimProduct['ProductAtt11'] ?? "";
					$integrationProduct->ProductAtt12 = $nebimProduct['ProductAtt12'] ?? "";
					$integrationProduct->ProductAtt13 = $nebimProduct['ProductAtt13'] ?? "";
					$integrationProduct->ProductAtt14 = $nebimProduct['ProductAtt14'] ?? "";
					$integrationProduct->ProductAtt15 = $nebimProduct['ProductAtt15'] ?? "";
					$integrationProduct->ProductAtt16 = $nebimProduct['ProductAtt16'] ?? "";
					$integrationProduct->ProductAtt17 = $nebimProduct['ProductAtt17'] ?? "";
					$integrationProduct->ProductAtt18 = $nebimProduct['ProductAtt18'] ?? "";
					$integrationProduct->ProductAtt19 = $nebimProduct['ProductAtt19'] ?? "";
					$integrationProduct->ProductAtt20 = $nebimProduct['ProductAtt20'] ?? "";
					$integrationProduct->ProductAtt21 = $nebimProduct['ProductAtt21'] ?? "";
					$integrationProduct->ProductAtt22 = $nebimProduct['ProductAtt22'] ?? "";
					$integrationProduct->ProductAtt23 = $nebimProduct['ProductAtt23'] ?? "";
					$integrationProduct->ProductAtt24 = $nebimProduct['ProductAtt24'] ?? "";
					$integrationProduct->ProductAtt25 = $nebimProduct['ProductAtt25'] ?? "";
					$integrationProduct->ProductAtt26 = $nebimProduct['ProductAtt26'] ?? "";
					$integrationProduct->ProductAtt27 = $nebimProduct['ProductAtt27'] ?? "";
					$integrationProduct->ProductAtt01Desc = $nebimProduct['ProductAtt01Desc'] ?? "";
					$integrationProduct->ProductAtt02Desc = $nebimProduct['ProductAtt02Desc'] ?? "";
					$integrationProduct->ProductAtt03Desc = $nebimProduct['ProductAtt03Desc'] ?? "";
					$integrationProduct->ProductAtt04Desc = $nebimProduct['ProductAtt04Desc'] ?? "";
					$integrationProduct->ProductAtt05Desc = $nebimProduct['ProductAtt05Desc'] ?? "";
					$integrationProduct->ProductAtt06Desc = $nebimProduct['ProductAtt06Desc'] ?? "";
					$integrationProduct->ProductAtt07Desc = $nebimProduct['ProductAtt07Desc'] ?? "";
					$integrationProduct->ProductAtt08Desc = $nebimProduct['ProductAtt08Desc'] ?? "";
					$integrationProduct->ProductAtt09Desc = $nebimProduct['ProductAtt09Desc'] ?? "";
					$integrationProduct->ProductAtt10Desc = $nebimProduct['ProductAtt10Desc'] ?? "";
					$integrationProduct->ProductAtt11Desc = $nebimProduct['ProductAtt11Desc'] ?? "";
					$integrationProduct->ProductAtt12Desc = $nebimProduct['ProductAtt12Desc'] ?? "";
					$integrationProduct->ProductAtt13Desc = $nebimProduct['ProductAtt13Desc'] ?? "";
					$integrationProduct->ProductAtt14Desc = $nebimProduct['ProductAtt14Desc'] ?? "";
					$integrationProduct->ProductAtt15Desc = $nebimProduct['ProductAtt15Desc'] ?? "";
					$integrationProduct->ProductAtt16Desc = $nebimProduct['ProductAtt16Desc'] ?? "";
					$integrationProduct->ProductAtt17Desc = $nebimProduct['ProductAtt17Desc'] ?? "";
					$integrationProduct->ProductAtt18Desc = $nebimProduct['ProductAtt18Desc'] ?? "";
					$integrationProduct->ProductAtt19Desc = $nebimProduct['ProductAtt19Desc'] ?? "";
					$integrationProduct->ProductAtt20Desc = $nebimProduct['ProductAtt20Desc'] ?? "";
					$integrationProduct->ProductAtt21Desc = $nebimProduct['ProductAtt21Desc'] ?? "";
					$integrationProduct->ProductAtt22Desc = $nebimProduct['ProductAtt22Desc'] ?? "";
					$integrationProduct->ProductAtt23Desc = $nebimProduct['ProductAtt23Desc'] ?? "";
					$integrationProduct->ProductAtt24Desc = $nebimProduct['ProductAtt24Desc'] ?? "";
					$integrationProduct->ProductAtt25Desc = $nebimProduct['ProductAtt25Desc'] ?? "";
					$integrationProduct->ProductAtt26Desc = $nebimProduct['ProductAtt26Desc'] ?? "";
					$integrationProduct->ProductAtt27Desc = $nebimProduct['ProductAtt27Desc'] ?? "";
					$integrationProduct->ProductAtt28Desc = $nebimProduct['ProductAtt28Desc'] ?? "";
					$integrationProduct->Price2 = $nebimProduct['Price2'] ?? "";
					$integrationProduct->StockCode = $stockCode;
					$integrationProduct->save();
				}

				$integrationProducts = IntegrationProducts::selectRaw('DISTINCT ProductCode,ColorCode,StockCode')->where('integrationId', $project->id)->get();

				foreach ($integrationProducts as $integrationProduct) {

					$opProduct = OpProduct::where('model', $integrationProduct->StockCode)->first();

					if (!$opProduct) {

						$findIntegrationProduct = IntegrationProducts::where('StockCode', $integrationProduct->StockCode)->where('integrationId', $project->id)->first();

						if (strlen($findIntegrationProduct->ItemDim1Code) > 0) {
							$barcode = "";
						} else {
							$barcode = $findIntegrationProduct->Barcode;
						}

						$barcode = $findIntegrationProduct->Barcode;

						$opProduct = new OpProduct();
						$opProduct->model = $integrationProduct->StockCode;
						$opProduct->sku = $integrationProduct->ProductCode;
						$opProduct->upc = "";
						$opProduct->ean = $barcode;
						$opProduct->jan = "";
						$opProduct->isbn = "";
						$opProduct->mpn = "";
						$opProduct->location = "";
						$opProduct->quantity = 0;
						$opProduct->stock_status_id = 7;
						$opProduct->image = "";
						$opProduct->manufacturer_id = 1;
						$opProduct->shipping = "1";
						$opProduct->price = $findIntegrationProduct->Price1;
						$opProduct->points = "0";
						$opProduct->tax_class_id = "0";
						$opProduct->date_available = date("Y-m-d");
						$opProduct->weight = "0.00000000";
						$opProduct->weight_class_id = "1";
						$opProduct->length = "0.00000000";
						$opProduct->width = "0.00000000";
						$opProduct->height = "0.00000000";
						$opProduct->length_class_id = "1";
						$opProduct->subtract = "0";
						$opProduct->minimum = "1";
						$opProduct->sort_order = "1";
						$opProduct->status = "1";
						$opProduct->viewed = "0";
						$opProduct->date_added = date("Y-m-d H:i:s");
						$opProduct->date_modified = date("Y-m-d H:i:s");

						if ($project->name == "tudors.ba") {
							$opProduct->meta_robots = "";
							$opProduct->seo_canonical = "";
						}
						$opProduct->save();

						$productId = $opProduct->id;

						if (strlen($findIntegrationProduct->ProductAtt21Desc) == 0) {
							$productName = $findIntegrationProduct->ProductAtt06Desc . " " . $findIntegrationProduct->ColorGroupDescription . " " . $findIntegrationProduct->ProductAtt27Desc;
						} else {
							//$productName = $findIntegrationProduct->ProductAtt21Desc . " " . $findIntegrationProduct->ProductAtt06Desc . " " . $findIntegrationProduct->ColorGroupDescription . " " . $findIntegrationProduct->ProductAtt27Desc;
							$productName = $findIntegrationProduct->ProductAtt21Desc . " " . $findIntegrationProduct->ProductAtt27Desc;
						}

						$description = $findIntegrationProduct->ProductAtt07Desc . "<br>" . $findIntegrationProduct->ProductAtt22Desc;
						$descriptionSecond = $findIntegrationProduct->ProductAtt07Desc . " " . $findIntegrationProduct->ProductAtt22Desc;

						$opProductDescription = new OpProductDescription();
						$opProductDescription->product_id = $productId;
						$opProductDescription->language_id = "1";
						$opProductDescription->name = $productName;
						$opProductDescription->description = $description;
						$opProductDescription->tag = "";
						$opProductDescription->meta_title = $productName;
						$opProductDescription->meta_description = $descriptionSecond;
						$opProductDescription->meta_keyword = "";

						if ($project->name == "tudors.ba") {
							$opProductDescription->seo_keyword = "";
							$opProductDescription->seo_h1 = "";
							$opProductDescription->seo_h2 = "";
							$opProductDescription->seo_h3 = "";
							$opProductDescription->image_title = "";
							$opProductDescription->image_alt = "";
						}
						$opProductDescription->save();

						$opProductToStore = new OpProductToStore();
						$opProductToStore->product_id = $productId;
						$opProductToStore->store_id = "0";
						$opProductToStore->save();

						$opProductToLayout = new OpProductToLayout();
						$opProductToLayout->product_id = $productId;
						$opProductToLayout->store_id = "0";
						$opProductToLayout->layout_id = "0";
						$opProductToLayout->save();

						$category = OpCategory::where('nebim_cat_code', $findIntegrationProduct->ProductAtt27)->where('nebim_cat_code2', "0")->first();
						if ($category) {
							$opProductToCategory = new OpProductToCategory();
							$opProductToCategory->product_id = $productId;
							$opProductToCategory->category_id = $category->category_id;
							$opProductToCategory->save();
						}

						if ($findIntegrationProduct->ProductAtt21 != "" || $findIntegrationProduct->ProductAtt27) {
							$categorySecond = OpCategory::where('nebim_cat_code', $findIntegrationProduct->ProductAtt27)->where('nebim_cat_code2', $findIntegrationProduct->ProductAtt21)->first();
							if ($categorySecond) {
								$opProductToCategorySecond = new OpProductToCategory();
								$opProductToCategorySecond->product_id = $productId;
								$opProductToCategorySecond->category_id = $categorySecond->category_id;
								$opProductToCategorySecond->save();
							}
						}

					}

				}

				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code='Antrasit' WHERE option_value_id = 1;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Bela' WHERE option_value_id = 2;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Bež' WHERE option_value_id = 3;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Bordo' WHERE option_value_id = 4;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Braon' WHERE option_value_id = 5;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Cigla' WHERE option_value_id = 6;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Ciklama' WHERE option_value_id = 7;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Cimet' WHERE option_value_id = 8;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Crna' WHERE option_value_id = 9;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Crvena' WHERE option_value_id = 10;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Dore' WHERE option_value_id = 11;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Duvan' WHERE option_value_id = 12;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Indigo' WHERE option_value_id = 13;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Kaki' WHERE option_value_id = 14;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Kamen' WHERE option_value_id = 15;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Kombinovana' WHERE option_value_id = 16;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Krem' WHERE option_value_id = 17;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Lila' WHERE option_value_id = 18;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Ljubičasta' WHERE option_value_id = 19;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Mint' WHERE option_value_id = 20;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Mornarsko plava' WHERE option_value_id = 21;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Narandžasta' WHERE option_value_id = 22;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Pesak' WHERE option_value_id = 23;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Petrol' WHERE option_value_id = 24;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Plava' WHERE option_value_id = 25;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Puder roze' WHERE option_value_id = 26;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Roze' WHERE option_value_id = 27;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Sax Plava' WHERE option_value_id = 28;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Senf' WHERE option_value_id = 29;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Siva' WHERE option_value_id = 30;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Srebrna' WHERE option_value_id = 31;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Svetlo smeđa' WHERE option_value_id = 32;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Tamno siva' WHERE option_value_id = 33;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Tirkiz' WHERE option_value_id = 34;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Zelena' WHERE option_value_id = 35;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Zlatna' WHERE option_value_id = 36;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'Žuta' WHERE option_value_id = 37;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'L' WHERE option_value_id = 38;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'M' WHERE option_value_id = 39;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'XL' WHERE option_value_id = 40;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'S' WHERE option_value_id = 41;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'XXL' WHERE option_value_id = 42;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = '2XL' WHERE option_value_id = 43;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = '3XL' WHERE option_value_id = 44;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = '4XL' WHERE option_value_id = 45;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'XS' WHERE option_value_id = 46;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'A' WHERE option_value_id = 47;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'I' WHERE option_value_id = 48;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'N' WHERE option_value_id = 49;");
				\Illuminate\Support\Facades\DB::statement("UPDATE oc_option_value set code = 'STD' WHERE option_value_id = 50;");

				$integrationProducts = IntegrationProducts::where('integrationId', $project->id)->get();

				foreach ($integrationProducts as $integrationProduct) {
					if (strlen($integrationProduct->ItemDim1Code) > 0) {
						$opProduct = OpProduct::where('model', $integrationProduct->StockCode)->first();
						if ($opProduct) {
							$opOptionValue = OpOptionValue::where('code', $integrationProduct->ItemDim1Code)->first();
							if ($opOptionValue) {
								echo $integrationProduct->StockCode . " ItemDim1Code: " . $integrationProduct->ItemDim1Code . " Barcode: " . $integrationProduct->Barcode . " < hr>";

								$opProductOption = OpProductOption::where('product_id', $opProduct->product_id)->where('option_id', "11")->first();
								if (!$opProductOption) {
									$newOpProductOption = new OpProductOption();
									$newOpProductOption->product_id = $opProduct->product_id;
									$newOpProductOption->option_id = "11";
									$newOpProductOption->value = "";
									$newOpProductOption->required = "1";
									$newOpProductOption->save();
									$sizeId = $newOpProductOption->id;
								} else {
									$sizeId = $opProductOption->product_option_id;
								}

								$opProductOptionValue = OpProductOptionValue::where('ean', $integrationProduct->Barcode)->first();
								if (!$opProductOptionValue) {
									$newOpProductOptionValue = new OpProductOptionValue();
									$newOpProductOptionValue->product_option_id = $sizeId;
									$newOpProductOptionValue->product_id = $opProduct->product_id;
									$newOpProductOptionValue->option_id = "11";
									$newOpProductOptionValue->option_value_id = $opOptionValue->option_value_id;
									$newOpProductOptionValue->quantity = 0;
									$newOpProductOptionValue->subtract = "1";
									$newOpProductOptionValue->price = "0.0000";
									$newOpProductOptionValue->price_prefix = "+";
									$newOpProductOptionValue->points = "0";
									$newOpProductOptionValue->points_prefix = "+";
									$newOpProductOptionValue->weight = "0.00000000";
									$newOpProductOptionValue->weight_prefix = "+";
									$newOpProductOptionValue->sku = $integrationProduct->StockCode;
									$newOpProductOptionValue->ean = $integrationProduct->Barcode;
									$newOpProductOptionValue->save();
								}

							}

						}
					}
				}

				$integrationProducts = IntegrationProducts::where('integrationId', $project->id)->get();
				foreach ($integrationProducts as $integrationProduct) {

					$opProduct = OpProduct::where('model', $integrationProduct->StockCode)->first();
					if ($opProduct) {

						if (strlen($integrationProduct->ProductAtt27Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "34")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "34";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt27Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt21Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "35")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "35";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt21Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt06Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "36")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "36";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt06Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ColorGroupDescription) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "46")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "46";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ColorGroupDescription;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt03Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "37")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "37";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt03Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt02Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "38")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "38";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt02Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt09Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "51")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "51";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt09Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt17Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "41")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "41";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt17Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt22Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "42")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "42";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt22Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt07Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "43")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "43";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt07Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt20Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "44")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "44";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt20Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt05Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "40")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "40";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt05Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt23Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "47")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "47";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt23Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt25Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "49")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "49";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt25Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt24Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "48")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "48";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt24Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt13Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "39")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "39";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt13Desc;
								$newOpProductAttribute->save();
							}
						}

						if (strlen($integrationProduct->ProductAtt07Desc) > 0) {
							$opProductAttribute = OpProductAttribute::where('product_id', $opProduct->product_id)->where('attribute_id', "43")->first();
							if (!$opProductAttribute) {
								$newOpProductAttribute = new OpProductAttribute();
								$newOpProductAttribute->product_id = $opProduct->product_id;
								$newOpProductAttribute->attribute_id = "39";
								$newOpProductAttribute->language_id = "1";
								$newOpProductAttribute->text = $integrationProduct->ProductAtt07Desc;
								$newOpProductAttribute->save();
							}
						}
					}
				}
				Logs::createLog($project->id, "Product transfer finished.", 0);

			} catch (\Exception $e) {
				Logs::createLog($project->id, $e->getMessage(), 1);
			}
		}
		return 0;
	}
}
