<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Logs;
use App\Models\ProjectSettings;
use Illuminate\Support\Facades\Mail;

class ErrorLogsSendMail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:logmail';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $projectname =  ProjectSettings::first()->project_name;
        $logs = Logs::where('sended_mail', 0)->where('has_error',1)->get();

        foreach ($logs as $l) {
            Mail::send("errormail", ["name" => "Tudors Error Log",'logs' => $l], function ($message) use ($projectname,$l) {
                $message->to("error@tudors.com", "Error")->subject($projectname." -  Integrator hata bildirimi. #". $l->id);
            });
            $l->sended_mail = 1;
            $l->save();
        }

        $simdi = now()->subDays(7);

        $logs = Logs::where('created_at','<',$simdi)->delete();


        return 0;
    }
}